/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.bigquery;

import com.google.api.client.util.Strings;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.Union;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.provider.bigquery.GoogleBigQueryResultSet;
import com.rapidminer.extension.indatabase.provider.bigquery.GoogleBigQueryRunner;
import com.rapidminer.extension.indatabase.provider.jdbc.JdbcQueryRunner;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.bigquery.UnionBigQuerySql;
import com.rapidminer.extension.indatabase.sql.mysql.JoinMySql;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.ParameterService;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public enum GoogleBigQueryProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "googleBigQuery";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;
    private static final String PARAMETER_USE_QUERY_CACHE = "use_query_cache";

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public List<String> getProjectNames(CachedDatabaseHandler handler) throws SQLException {
        return Arrays.asList("<default_project>", "bigquery-public-data");
    }

    @Override
    public List<String> getSchemaNames(CachedDatabaseHandler handler) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        LOGGER.fine("Finding shemas");
        try {
            handler.getBigQuery().listDatasets(new BigQuery.DatasetListOption[0]).iterateAll().forEach(s -> schemas.add(s.getDatasetId().getDataset()));
        }
        catch (BigQueryException e) {
            throw new SQLException(e);
        }
        LOGGER.fine("Done finding shemas");
        return DbTools.sortedList(schemas);
    }

    @Override
    public List<String> getSchemaNames(CachedDatabaseHandler handler, String projectName) throws SQLException {
        if (Strings.isNullOrEmpty((String)projectName)) {
            return this.getSchemaNames(handler);
        }
        ArrayList<String> schemas = new ArrayList<String>();
        LOGGER.fine(() -> String.format("Finding shemas in '%s'", projectName));
        try {
            handler.getBigQuery().listDatasets(projectName, new BigQuery.DatasetListOption[0]).iterateAll().forEach(s -> schemas.add(s.getDatasetId().getDataset()));
        }
        catch (BigQueryException e) {
            throw new SQLException(e);
        }
        LOGGER.fine(() -> String.format("Done finding shemas in '%s'", projectName));
        return DbTools.sortedList(schemas);
    }

    @Override
    public List<String> getTableNames(CachedDatabaseHandler handler, String schemaName) throws SQLException, OperatorException {
        return this.getTableNames(handler, null, schemaName);
    }

    @Override
    public List<String> getTableNames(CachedDatabaseHandler handler, String projectName, String schemaName) throws SQLException, OperatorException {
        ArrayList<String> tableList = new ArrayList<String>();
        Object sqlQuery = String.format("SELECT TABLE_NAME FROM %s.INFORMATION_SCHEMA.TABLES", Strings.isNullOrEmpty((String)projectName) ? this.quote(schemaName) : String.format("%s.%s", this.quote(projectName), this.quote(schemaName)));
        if (Boolean.parseBoolean(ParameterService.getParameterValue((String)"rapidminer.tools.db.assist.show_only_standard_tables"))) {
            sqlQuery = (String)sqlQuery + String.format(" WHERE TABLE_TYPE = %s", this.literal("BASE TABLE"));
        }
        LOGGER.fine(() -> String.format("Finding tables in schema '%s'.'%s'", projectName, schemaName));
        try (QueryRunner qR = this.createQueryRunner(handler);){
            ExampleSet resultEs = qR.executeQuery((String)sqlQuery).createExampleTable(null).build();
            Attribute onlyAttr = (Attribute)resultEs.getAttributes().allAttributes().next();
            resultEs.forEach(e -> tableList.add(e.getNominalValue(onlyAttr)));
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        LOGGER.fine(() -> String.format("Done finding tables in schema '%s'.'%s'", projectName, schemaName));
        return DbTools.sortedList(tableList);
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public boolean supportsInfinity() {
        return false;
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinMySql());
        res.put(Union.class, new UnionBigQuerySql());
        return res;
    }

    @Override
    public String getEnclosingCharacter() {
        return "`";
    }

    @Override
    public String escapeLiteral(String val) {
        return val.replace(this.getLiteralEnclosingCharacter(), "\\" + this.getLiteralEnclosingCharacter());
    }

    @Override
    public String escapeLikeExpr(String str) {
        return str.replace("%", "\\\\%");
    }

    @Override
    public String format(String val, Column c) {
        if (!this.isLiteral(val)) {
            int type = DbMetaDataTools.getRapidMinerTypeIndex(c.getType());
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 9)) {
                String dateVal;
                try {
                    Date date = DbTools.RAPIDMINER_FORMAT_DATE_TIME.get().parse(val);
                    dateVal = GoogleBigQueryResultSet.FORMAT_BIGQUERY_DATE_TIME.get().format(date);
                }
                catch (ParseException e) {
                    dateVal = val;
                }
                return this.literal(dateVal);
            }
            return DatabaseProvider.super.format(val, c);
        }
        return val;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("BIGNUMERIC", 8);
        res.put("BOOL", 12);
        res.put("DATE", 91);
        res.put("DATETIME", 93);
        res.put("FLOAT64", 8);
        res.put("INT64", 4);
        res.put("NUMERIC", 2);
        res.put("STRING", 4);
        res.put("TIME", 92);
        res.put("TIMESTAMP", 93);
        return res;
    }

    @Override
    public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        Map<Filter.FilterCondition, BiFunction<String, String, String>> filterSyntax = DatabaseProvider.super.getFilterSyntax();
        filterSyntax.put(Filter.FilterCondition.MATCHES, (col, val) -> "REGEXP_CONTAINS(" + col + ", " + this.literal("^" + val + "$") + ")");
        return filterSyntax;
    }

    @Override
    public QueryRunner createQueryRunner(CachedDatabaseHandler handler) throws SQLException {
        if (handler.isDatabaseConnection()) {
            return new JdbcQueryRunner(handler);
        }
        Operator nest = handler.getOperator();
        Objects.requireNonNull(nest, "Nest not found when creating query runner.");
        return new GoogleBigQueryRunner(handler, nest.getParameterAsBoolean(PARAMETER_USE_QUERY_CACHE));
    }

    @Override
    public boolean supportsProjects() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = DatabaseProvider.super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_USE_QUERY_CACHE, "Set this to false to disable the remote query cache that stores temporary results. You may want to do that if you expect different results for the same queries, e.g. dropping and re-creating a table with a different structure. Note that this setting only works in case of a BigQuery connection and not a JDBC connection. For more information, please refer to the guide about using cached query results in BigQuery documentation.", true, true));
        return types;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 50, "jdbc:bigquery:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("ANY_VALUE", "any", "Returns any value from the input or NULL if there are zero input rows. (non-deterministic)", -1000), new FunctionDefinition("ARRAY_AGG", "concatenate (into array)", "Returns an ARRAY of expression values.", 5), new FunctionDefinition("ARRAY_CONCAT_AGG", "concatenate arrays (into array)", "Concatenates elements from column of type ARRAY, returning a single ARRAY as a result.", 5), new FunctionDefinition("AVG", "average", "Returns the average of non-NULL input values, or NaN if the input contains a NaN.", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "Returns the average of non-NULL, distinct input values, or NaN if the input contains a NaN.", -1000), new FunctionDefinition("BIT_AND", "bitwise and", "Performs a bitwise AND operation on column and returns the result.", -1000), new FunctionDefinition("BIT_OR", "bitwise or", "Performs a bitwise OR operation on column and returns the result.", -1000), new FunctionDefinition("BIT_XOR", "bitwise  xor", "Performs a bitwise XOR operation on column and returns the result.", -1000), new FunctionDefinition("COUNT", "count", "Returns the number of rows in the input.", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "Returns the number of distinct, non-null rows in the input.", 3), new FunctionDefinition("LOGICAL_AND", "logical and", "Returns the logical AND of all non-NULL values. Returns NULL if there are zero input rows or expression evaluates to NULL for all rows.", 6), new FunctionDefinition("LOGICAL_OR", "logical or", "Returns the logical OR of all non-NULL values. Returns NULL if there are zero input rows or expression evaluates to NULL for all rows.", 6), new FunctionDefinition("MAX", "maximum", "Returns the maximum value.", -1000), new FunctionDefinition("MIN", "minimum", "Returns the minimum value.", -1000), new FunctionDefinition("STRING_AGG", "concatenate (into string array)", "Returns a value (either STRING or BYTES) obtained by concatenating non-null values.", 5), new FunctionDefinition("SUM", "sum", "Returns the sum of non-null values.", -1000), new FunctionDefinition("SUM(DISTINCT)", "sum (distinct rows)", "Returns the sum of non-null, distinct values.", -1000), new FunctionDefinition("STDDEV_POP", "standard deviation", "Returns the population (biased) standard deviation of the values. ", -1000), new FunctionDefinition("STDDEV_POP(DISTINCT)", "standard deviation (distinct rows)", "Returns the population (biased) standard deviation of the distinct values. ", -1000), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "Returns the sample (unbiased) standard deviation of the values. ", -1000), new FunctionDefinition("STDDEV_SAMP(DISTINCT)", "sample standard deviation (distinct rows)", "Returns the sample (unbiased) standard deviation of the distinct values. ", -1000), new FunctionDefinition("VAR_POP", "variance", "Returns the population (biased) variance of the values.", -1000), new FunctionDefinition("VAR_POP(DISTINCT)", "variance (distinct rows)", "Returns the population (biased) variance of the distinct values.", -1000), new FunctionDefinition("VAR_SAMP", "sample variance", "Returns the sample (unbiased) variance of the values.", -1000), new FunctionDefinition("VAR_POP(DISTINCT)", "variance (distinct rows)", "Returns the sample (unbiased) variance of the distinct values.", -1000), new FunctionDefinition("APPROX_COUNT_DISTINCT", "approximate count", "Returns the approximate result for COUNT(DISTINCT column).", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

