/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.utils.ExampleSetBuilder;
import com.rapidminer.example.utils.ExampleSets;
import com.rapidminer.extension.indatabase.provider.IndbResultSet;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.parameter.internal.DataManagementParameterHelper;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GoogleBigQueryResultSet
implements IndbResultSet {
    private final TableResult tableResult;
    private final Set<String> errors = new LinkedHashSet<String>();
    private static final ThreadLocal<DateFormat> FORMAT_BIGQUERY_DATE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH));
    private static final ThreadLocal<DateFormat> FORMAT_BIGQUERY_TIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss".replace("yyyy-MM-dd ", ""), Locale.ENGLISH));
    public static final ThreadLocal<DateFormat> FORMAT_BIGQUERY_DATE_TIME = ThreadLocal.withInitial(() -> {
        SimpleDateFormat res = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        res.setTimeZone(TimeZone.getTimeZone("GMT"));
        return res;
    });

    public GoogleBigQueryResultSet(TableResult tR) {
        this.tableResult = tR;
    }

    @Override
    public void close() throws SQLException {
    }

    private static JDBCType sqlTypeOf(Field field, Set<String> errs) {
        LegacySQLTypeName type = field.getType();
        StandardSQLTypeName standardType = type.getStandardType();
        if (standardType == null) {
            errs.add(String.format("Unknown BigQuery standard SQL equivalent type for legacy type in column '%s': %s. Reading it as VARCHAR.", field.getName(), type.name()));
            return JDBCType.VARCHAR;
        }
        String[] types = new String[]{type.toString().toLowerCase(), standardType.toString().toLowerCase()};
        if ("string".equals(types[0])) {
            return JDBCType.VARCHAR;
        }
        if ("datetime".equals(types[0]) || "timestamp".equals(types[0])) {
            return JDBCType.TIMESTAMP;
        }
        if ("bignumeric".equals(types[0])) {
            return JDBCType.FLOAT;
        }
        for (JDBCType sqlType : (JDBCType[])JDBCType.class.getEnumConstants()) {
            String sqlTypeLowerCase = sqlType.toString().toLowerCase();
            for (String typeStr : types) {
                if (!typeStr.equals(sqlTypeLowerCase)) continue;
                return sqlType;
            }
            for (String typeStr : types) {
                if (!typeStr.startsWith(sqlTypeLowerCase)) continue;
                return sqlType;
            }
        }
        throw new IllegalArgumentException("Type: " + String.valueOf(type) + " is not a valid Types value.");
    }

    @Override
    public ExampleSetBuilder createExampleTable(Operator op) throws SQLException, OperatorException {
        Schema schema = this.tableResult.getSchema();
        List<Attribute> attributes = schema.getFields().stream().map(f -> {
            int attributeType = DatabaseHandler.getRapidMinerTypeIndex((int)GoogleBigQueryResultSet.sqlTypeOf(f, this.errors).getVendorTypeNumber());
            Attribute attribute = AttributeFactory.createAttribute((String)f.getName(), (int)attributeType);
            StandardSQLTypeName type = f.getType().getStandardType();
            attribute.getAnnotations().setAnnotation("sql_type", type != null ? type.toString() : f.getType().name());
            return attribute;
        }).collect(Collectors.toList());
        Attribute[] attributeArray = attributes.toArray(new Attribute[attributes.size()]);
        ExampleSetBuilder builder = ExampleSets.from(attributes);
        if (op != null) {
            try {
                builder.withOptimizationHint(DataManagementParameterHelper.getSelectedDataManagement((Operator)op));
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
        DataRowFactory factory = new DataRowFactory(0, '.');
        Logger logger = Logger.getGlobal();
        int rowcounter = 0;
        for (FieldValueList row : this.tableResult.iterateAll()) {
            DataRow dataRow = factory.create(attributeArray.length);
            int i = 0;
            for (FieldValue val : row) {
                double value;
                Attribute attribute = attributeArray[i];
                int valueType = attribute.getValueType();
                if (val.isNull()) {
                    value = Double.NaN;
                } else {
                    String DATEFORMAT_ERROR_MESSAGE = "Datetime format error:";
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 10)) {
                        try {
                            value = FORMAT_BIGQUERY_DATE.get().parse(val.getStringValue()).getTime();
                        }
                        catch (ParseException e) {
                            throw new SQLException("Datetime format error:", e);
                        }
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 11)) {
                        try {
                            value = FORMAT_BIGQUERY_TIME.get().parse(val.getStringValue()).getTime();
                        }
                        catch (ParseException e) {
                            throw new SQLException("Datetime format error:", e);
                        }
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 9)) {
                        try {
                            String valStr = val.getStringValue();
                            if (valStr.contains("T")) {
                                value = FORMAT_BIGQUERY_DATE_TIME.get().parse(valStr.replace('T', ' ')).getTime();
                            }
                            value = new Date((long)Double.parseDouble(val.getStringValue()) * 1000L).getTime();
                        }
                        catch (ParseException e) {
                            throw new SQLException("Datetime format error:", e);
                        }
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 2)) {
                        value = val.getDoubleValue();
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(valueType, 1)) {
                        String valueString = val.getStringValue();
                        value = valueString == null ? Double.NaN : (double)attribute.getMapping().mapString(valueString);
                    } else {
                        if (logger != null) {
                            logger.warning(() -> String.format("Unknown column type: %s", attribute));
                            logger = null;
                        }
                        value = Double.NaN;
                    }
                }
                dataRow.set(attribute, value);
                ++i;
            }
            builder.addDataRow(dataRow);
            if (op == null || ++rowcounter % 100 != 0) continue;
            op.checkForStop();
        }
        return builder;
    }

    @Override
    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }
}

