/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.TableResult;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.provider.CancellableQueryRunner;
import com.rapidminer.extension.indatabase.provider.IndbResultSet;
import com.rapidminer.extension.indatabase.provider.bigquery.GoogleBigQueryResultSet;
import java.sql.SQLException;

public class GoogleBigQueryRunner
extends CancellableQueryRunner {
    private final BigQuery bigQuery;
    private JobId jobId = null;
    private final boolean useQueryCache;

    public GoogleBigQueryRunner(CachedDatabaseHandler handler) {
        this(handler, true);
    }

    public GoogleBigQueryRunner(CachedDatabaseHandler handler, boolean useQueryCache) {
        super(handler.getOperator());
        this.bigQuery = handler.getBigQuery();
        this.useQueryCache = useQueryCache;
    }

    @Override
    public IndbResultSet doExecuteQuery(String query) throws SQLException, InterruptedException {
        this.logStatement(query, true);
        QueryJobConfiguration queryConfig = this.buildQueryConfiguration(query);
        return new GoogleBigQueryResultSet(this.run(queryConfig));
    }

    @Override
    public void doExecute(String statement) throws SQLException, InterruptedException {
        this.logStatement(statement, false);
        QueryJobConfiguration queryConfig = this.buildQueryConfiguration(statement);
        GoogleBigQueryResultSet rs = new GoogleBigQueryResultSet(this.run(queryConfig));
        rs.close();
    }

    @Override
    public void cancel() throws SQLException {
        this.bigQuery.cancel(this.jobId);
    }

    @Override
    public void close() throws SQLException {
        if (this.jobId != null) {
            this.cancel();
        }
    }

    private TableResult run(QueryJobConfiguration queryConfig) throws SQLException, InterruptedException {
        TableResult tableResult;
        try {
            this.jobId = JobId.of();
            tableResult = this.bigQuery.query(queryConfig, this.jobId, new BigQuery.JobOption[0]);
        }
        catch (BigQueryException | JobException e) {
            throw new SQLException(e.getMessage(), e);
        }
        return tableResult;
    }

    private QueryJobConfiguration buildQueryConfiguration(String statement) {
        return QueryJobConfiguration.newBuilder((String)statement).setUseQueryCache(Boolean.valueOf(this.useQueryCache)).build();
    }
}

