/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.databricks;

import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.shared.JoinFullOuterSql;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public enum DatabricksProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "databricks";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public String getEnclosingCharacter() {
        return "`";
    }

    @Override
    public String escapeLiteral(String val) {
        return val.replace(this.getLiteralEnclosingCharacter(), "\\" + this.getLiteralEnclosingCharacter());
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinFullOuterSql());
        return res;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("BIGINT", 8);
        res.put("BINARY", 12);
        res.put("BOOLEAN", 12);
        res.put("DATE", 91);
        res.put("DECIMAL", 8);
        res.put("DOUBLE", 8);
        res.put("FLOAT", 6);
        res.put("INT", 4);
        res.put("INTERVAL", 12);
        res.put("VOID", 12);
        res.put("SMALLINT", 4);
        res.put("TIMESTAMP", 93);
        res.put("TIMESTAMP_NZT", 93);
        res.put("TINYINT", 8);
        res.put("STRING", 12);
        return res;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 70, "jdbc:databricks:", "jdbc::databricks::"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("ANY", "any", "Returns true if at least one value of expr in the group is true.", -1000), new FunctionDefinition("ANY_VALUE", "any value", "Returns any random value of expr for a group of rows.", -1000), new FunctionDefinition("ARRAY_AGG", "concatenate (into array)", "Returns an array consisting of all values in expr within the group.", 5), new FunctionDefinition("AVG", "average", "Returns the mean calculated from values of a group.", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "Returns the mean calculated from distinct values of a group.", -1000), new FunctionDefinition("BIT_AND", "bitwise and", "Returns the bitwise AND of all input values in the group.", -1000), new FunctionDefinition("BIT_OR", "bitwise or", "Returns the bitwise OR of all input values in the group.", -1000), new FunctionDefinition("BIT_XOR", "bitwise xor", "Returns the bitwise XOR of all input values in the group.", -1000), new FunctionDefinition("BITMAP_CONSTRUCT_AGG", "bitmap_construct_agg", "Returns the bitwise OR of all bit position values in the group. between 0 and 32767 in a group as a BINARY.", -1000), new FunctionDefinition("BITMAP_OR_AGG", "bitmap_or_agg", "Returns the bitwise OR of all BINARY input values in the group.", -1000), new FunctionDefinition("BOOL_AND", "logical and", "Returns true if all values in expr are true within the group.", -1000), new FunctionDefinition("BOOL_OR", "logical or", "Returns true if at least one value in expr is true within the group.", -1000), new FunctionDefinition("COLLECT_LIST", "collect list", "Returns an array consisting of all values in expr within the group.", 5), new FunctionDefinition("COLLECT_SET", "collect set", "Returns an array consisting of all unique values in expr within the group.", 5), new FunctionDefinition("COUNT", "count", "Returns the total number of retrieved rows in a group, including rows containing null.", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "Returns the total number of retrieved distinct rows in a group, including rows containing null.", 3), new FunctionDefinition("COUNT_IF", "count if", "Returns the number of true values for the group in expr.", 3), new FunctionDefinition("EVERY", "every", "Returns true if all values of expr in the group are true.", -1000), new FunctionDefinition("FIRST", "first", "Returns the first value of expr for a group of rows.", -1000), new FunctionDefinition("FIRST_VALUE", "first value", "Returns the first value of expr for a group of rows.", -1000), new FunctionDefinition("HLL_SKETCH_AGG", "hll_sketch_agg", "Returns a HyperLogLog sketch used to approximate a distinct values count.", -1000), new FunctionDefinition("HLL_UNION_AGG", "hll_union_agg", "Aggregates HyperLogLog sketches for a group of rows.", -1000), new FunctionDefinition("KURTOSIS", "kurtosis", "Returns the kurtosis value calculated from values of a group..", -1000), new FunctionDefinition("LAST", "last", "Returns the last value of expr for the group of rows.", -1000), new FunctionDefinition("LAST_VALUE", "last value", "Returns the last value of expr for the group of rows.", -1000), new FunctionDefinition("MAX", "maximum", "Returns the maximum value of expr in a group.", -1000), new FunctionDefinition("MEAN", "mean", "Returns the mean calculated from values of a group.", -1000), new FunctionDefinition("MEDIAN", "median", "Returns the median calculated from values of a group.", -1000), new FunctionDefinition("MIN", "minimum", "Returns the minimum value of expr in a group.", -1000), new FunctionDefinition("MODE", "mode", "Returns the most frequent, not NULL, value of expr in a group.", -1000), new FunctionDefinition("SKEWNESS", "skewness", "Returns the skewness value calculated from values of a group.", -1000), new FunctionDefinition("SOME", "some", "Returns true if at least one value of expr in a group is true.", -1000), new FunctionDefinition("STD", "std", "Returns the sample standard deviation calculated from the values within the group.", -1000), new FunctionDefinition("STDDEV", "standard deviation", "Returns the population standard deviation calculated from values of a group.", -1000), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "Returns the sample standard deviation calculated from values of a group.", -1000), new FunctionDefinition("SUM", "sum", "Returns the sum calculated from values of a group.", -1000), new FunctionDefinition("TRY_AVG", "try avg", "Returns the mean calculated from values of a group, NULL if there is an overflow.", -1000), new FunctionDefinition("TRY_SUM", "try sum", "Returns the sum calculated from values of a group, NULL if there is an overflow.", -1000), new FunctionDefinition("VAR_POP", "variance", "Returns the population variance calculated from values of a group.", -1000), new FunctionDefinition("VAR_SAMP", "sample variance", "Returns the sample variance calculated from values of a group.", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

