/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.impala;

import com.google.common.base.Predicates;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.db.step.Select;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.provider.impala.ImpalaStorageFormat;
import com.rapidminer.extension.indatabase.provider.storage.CreateTableOptions;
import com.rapidminer.extension.indatabase.provider.storage.StorageFormat;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.impala.SampleImpala;
import com.rapidminer.extension.indatabase.sql.shared.JoinFullOuterSql;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImpalaProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "impala";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;
    private static final Pattern PARTITION_ATTRIBUTE_PATTERN;
    private static final Set<Integer> INVALID_KUDU_PK_SQL_TYPES;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public String getEnclosingCharacter() {
        return "`";
    }

    @Override
    public String escapeLiteral(String val) {
        String enclosingChar = this.getLiteralEnclosingCharacter();
        return val.replace(enclosingChar, "\\" + enclosingChar);
    }

    @Override
    public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        Map<Filter.FilterCondition, BiFunction<String, String, String>> filterSyntax = DatabaseProvider.super.getFilterSyntax();
        filterSyntax.put(Filter.FilterCondition.CONTAINS, (col, val) -> String.format(" INSTR(%s, %s) > 0 ", col, this.literal((String)val)));
        filterSyntax.put(Filter.FilterCondition.DOES_NOT_CONTAIN, (col, val) -> String.format(" INSTR(%s, %s) = 0 ", col, this.literal((String)val)));
        return filterSyntax;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("bigint", -5);
        res.put("boolean", 16);
        res.put("char(255)", 1);
        res.put("date", 91);
        res.put("decimal", 3);
        res.put("double", 8);
        res.put("float", 6);
        res.put("int", 4);
        res.put("real", 7);
        res.put("smallint", 5);
        res.put("string", 12);
        res.put("timestamp", 93);
        res.put("tinyint", -6);
        res.put("varchar(1000)", 12);
        return res;
    }

    @Override
    public QueryRunner createQueryRunner(CachedDatabaseHandler handler) throws SQLException {
        QueryRunner queryRunner = DatabaseProvider.super.createQueryRunner(handler);
        try {
            queryRunner.execute("SET SYNC_DDL=1");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Thread was interrupted while setting SYNC_DDL.", e);
        }
        return queryRunner;
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Sample.class, new SampleImpala());
        res.put(Join.class, new JoinFullOuterSql());
        return res;
    }

    @Override
    public String generateCreateTableSql(Table table, DbStep dbStep, CreateTableOptions options) {
        return ImpalaProvider.isKuduStorage(options) ? this.createTableKudu(table, dbStep, options) : this.createTableGeneric(table, dbStep, options);
    }

    private String createTableKudu(Table table, DbStep dbStep, CreateTableOptions options) {
        List<String> pkColumns = options.getPrimaryKeyColumns();
        String primaryKeys = pkColumns.stream().map(this::quote).collect(Collectors.joining(", "));
        String primaryKeyClause = !primaryKeys.isEmpty() ? (options.isNonUniquePK() ? " NON UNIQUE" : "") + " PRIMARY KEY (" + primaryKeys + ") " : "";
        List<Column> inputCols = dbStep.getColumnRefs(this);
        String partitionBy = options.getPartitionBy();
        List partitionColumns = partitionBy != null && !partitionBy.isEmpty() ? this.extractPartitionColumns(options.getPartitionBy()) : Collections.emptyList();
        Predicate<Column> isPkColumn = column -> pkColumns.contains(column.getDestCol()) || partitionColumns.contains(column.getDestCol());
        List<Column> createColsOrdered = inputCols.stream().filter(isPkColumn).collect(Collectors.toList());
        inputCols.stream().filter(isPkColumn.negate()).forEach(createColsOrdered::add);
        dbStep = Select.builder().from(dbStep).columns(createColsOrdered).build();
        String partitionClause = partitionBy != null && !partitionBy.isEmpty() ? " PARTITION BY " + Expression.replaceBrackets(this, partitionBy) : "";
        return String.format("CREATE TABLE %s  %s  %s  %s  STORED AS KUDU  %s  AS %s", table.toSql(this), primaryKeyClause, partitionClause, this.getCommentClause(options), this.getTblPropertiesClause(options), dbStep.toSql(this));
    }

    private String createTableGeneric(Table table, DbStep dbStep, CreateTableOptions options) {
        String partitionBy = options.getPartitionBy();
        String partitionClause = partitionBy != null && !partitionBy.isEmpty() ? " PARTITIONED BY (" + Expression.replaceBrackets(this, partitionBy) + ")" : "";
        String storedAs = options.getStoredAs();
        String storedAsClause = storedAs != null && !storedAs.isEmpty() && !storedAs.toUpperCase().equals(StorageFormat.DEFAULT.getName()) ? " STORED AS " + options.getStoredAs().toUpperCase() : "";
        String locationClause = options.getLocation() != null && !options.getLocation().isEmpty() ? " LOCATION " + this.literal(options.getLocation()) : "";
        String rowFormatClause = options.getRowFormat() != null && !options.getRowFormat().isEmpty() ? " ROW FORMAT " + options.getRowFormat() : "";
        String externalClause = options.isExternal() ? "EXTERNAL " : "";
        return String.format("CREATE %sTABLE %s  %s  %s  %s  %s  %s  %s  %s  AS %s", externalClause, table.toSql(this), partitionClause, this.getCommentClause(options), rowFormatClause, this.getSerdePropertiesClause(options), storedAsClause, locationClause, this.getTblPropertiesClause(options), dbStep.toSql(this));
    }

    private String getCommentClause(CreateTableOptions options) {
        String commentClause = options.getComment() != null && !options.getComment().isEmpty() ? " COMMENT " + this.literal(options.getComment()) : "";
        return commentClause;
    }

    private String getSerdePropertiesClause(CreateTableOptions options) {
        if (options.getSerdeProperties() == null || options.getSerdeProperties().isEmpty()) {
            return "";
        }
        String properties = this.formatPropertyKeyValuePairs(options.getSerdeProperties());
        return " WITH SERDEPROPERTIES (" + properties + ")";
    }

    private String getTblPropertiesClause(CreateTableOptions options) {
        if (options.getTblProperties() == null || options.getTblProperties().isEmpty()) {
            return "";
        }
        String properties = this.formatPropertyKeyValuePairs(options.getTblProperties());
        return " TBLPROPERTIES (" + properties + ")";
    }

    private String formatPropertyKeyValuePairs(Map<String, String> properties) {
        return properties.entrySet().stream().map(entry -> this.literal((String)entry.getKey()) + "=" + this.literal((String)entry.getValue())).collect(Collectors.joining(", "));
    }

    private List<String> extractPartitionColumns(String partitionClause) {
        Matcher matcher = PARTITION_ATTRIBUTE_PATTERN.matcher(partitionClause);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        String escapedQuote = Pattern.quote(this.getEnclosingCharacter());
        return Arrays.stream(matcher.group(1).split("\\s*,\\s*")).map(col -> col.replaceAll("\\[|\\]|^" + escapedQuote + "|" + escapedQuote + "$", "")).filter((Predicate<String>)Predicates.not(String::isEmpty)).collect(Collectors.toList());
    }

    public static boolean isAllowedKuduPkType(int sqlType) {
        return !INVALID_KUDU_PK_SQL_TYPES.contains(sqlType);
    }

    public static String getInvalidKuduPkTypesString() {
        return INVALID_KUDU_PK_SQL_TYPES.stream().map(ImpalaProvider::getImpalaTypeString).collect(Collectors.joining(", "));
    }

    public static String getImpalaTypeString(int sqlType) {
        return INSTANCE.getDataTypeSuggestions().entrySet().stream().filter(entry -> (Integer)entry.getValue() == sqlType).map(Map.Entry::getKey).findFirst().orElse("UNKNOWN");
    }

    public static boolean isKuduStorage(CreateTableOptions options) {
        return options != null && options.getStoredAs() != null && options.getStoredAs().toUpperCase().contains(ImpalaStorageFormat.KUDU.getName());
    }

    @Override
    public boolean isCustomFormatEnabled() {
        return true;
    }

    @Override
    public List<StorageFormat> getSupportedStorageFormats() {
        ArrayList<StorageFormat> formats = new ArrayList<StorageFormat>(DatabaseProvider.super.getSupportedStorageFormats());
        formats.addAll(Arrays.asList(ImpalaStorageFormat.values()));
        return formats;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 10, "jdbc:impala:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("avg", "average", "Return the average value of the argument.", -1000), new FunctionDefinition("avg(distinct)", "average (distinct rows)", "Return the average of the distinct values of the argument.", -1000), new FunctionDefinition("count", "count", "Return a count of the number of rows returned.", 3), new FunctionDefinition("count(distinct)", "count (distinct rows)", "Return the count of a number of different values.", 3), new FunctionDefinition("group_concat", "group concat", "Return a string representing the argument value concatenated together for each row", 5), new FunctionDefinition("max", "maximum", "Return the maximum value.", -1000), new FunctionDefinition("min", "minimum", "Return the minimum value.", -1000), new FunctionDefinition("stddev_pop", "standard deviation", "Return the population standard deviation.", -1000), new FunctionDefinition("stddev_samp", "sample standard deviation", "Return the sample standard deviation.", -1000), new FunctionDefinition("sum", "sum", "Return the sum.", -1000), new FunctionDefinition("variance_pop", "population variance", "Return the population standard variance.", -1000), new FunctionDefinition("variance_samp", "sample variance", "Return the sample variance.", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
        PARTITION_ATTRIBUTE_PATTERN = Pattern.compile("(?:HASH|RANGE)\\s*\\(\\s*([^)]+)\\s*\\)", 2);
        INVALID_KUDU_PK_SQL_TYPES = Set.of(Integer.valueOf(16), Integer.valueOf(6), Integer.valueOf(8));
    }
}

