/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.impala;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.provider.impala.ImpalaProvider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class KuduPrimaryKeyException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Set<Column> invalidColumns;

    public KuduPrimaryKeyException() {
        this.invalidColumns = Collections.emptySet();
    }

    public KuduPrimaryKeyException(Set<Column> invalidColumns) {
        this.invalidColumns = new LinkedHashSet<Column>(invalidColumns);
    }

    public Set<Column> getInvalidColumns() {
        return Collections.unmodifiableSet(this.invalidColumns);
    }

    public String getInvalidColumnsString() {
        return this.invalidColumns.stream().map(col -> String.format("'%s' (%s)", col.getDestCol(), ImpalaProvider.getImpalaTypeString(col.getType()))).collect(Collectors.joining(", "));
    }

    public boolean isMissing() {
        return this.invalidColumns.isEmpty();
    }

    @Override
    public String getMessage() {
        if (this.isMissing()) {
            return "Missing primary key for Kudu table.";
        }
        return String.format("Invalid attributes for Kudu primary keys: %s", this.getInvalidColumnsString());
    }
}

