/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.jdbc;

import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.provider.CancellableQueryRunner;
import com.rapidminer.extension.indatabase.provider.IndbResultSet;
import com.rapidminer.extension.indatabase.provider.jdbc.JdbcResultSet;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.LogService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class JdbcQueryRunner
extends CancellableQueryRunner {
    private final DatabaseHandler dbHandler;
    private final Statement statement;

    public JdbcQueryRunner(CachedDatabaseHandler dh) throws SQLException {
        super(dh.getOperator());
        this.dbHandler = dh.getConnectedDatabaseHandler();
        this.statement = this.dbHandler.createStatement(false, false);
    }

    @Override
    public IndbResultSet doExecuteQuery(String query) throws SQLException {
        this.logStatement(query, true);
        ResultSet rs = this.statement.executeQuery(query);
        return new JdbcResultSet(rs, this.getDbErrors());
    }

    List<String> getDbErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            for (SQLWarning warn = this.statement.getWarnings(); warn != null; warn = warn.getNextWarning()) {
                errors.add(warn.getMessage());
            }
        }
        catch (SQLException e) {
            LogService.getRoot().log(Level.WARNING, "Could not retrieve SQL warnings from db", e);
        }
        return errors;
    }

    @Override
    public void doExecute(String st) throws SQLException {
        this.logStatement(st, false);
        this.statement.execute(st);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.statement.close();
        }
        finally {
            this.dbHandler.close();
        }
    }

    protected final DatabaseHandler getDatabaseHandler() {
        return this.dbHandler;
    }
}

