/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.mssql;

import com.rapidminer.example.Attribute;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.AbsoluteSample;
import com.rapidminer.extension.indatabase.db.step.AggregationSubquery;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.ProbabilitySample;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.db.step.Sort;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.provider.jdbc.ConfigurableConnectionJdbcQueryRunner;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.mssql.AbsoluteSampleMSSql;
import com.rapidminer.extension.indatabase.sql.mssql.AggregationSubqueryMSSql;
import com.rapidminer.extension.indatabase.sql.mssql.ProbabilitySampleMSSql;
import com.rapidminer.extension.indatabase.sql.mssql.SampleMSSql;
import com.rapidminer.extension.indatabase.sql.mssql.SortMSSql;
import com.rapidminer.extension.indatabase.sql.shared.JoinFullOuterSql;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public enum MSSQLProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "mssql";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;
    static final String TEMPLATE_SELECT_INTO = "SELECT * INTO %s FROM (%s) %s";
    static final String TEMPLATE_INSERT_INTO = "INSERT INTO %s %s";
    private static final String PARAMETER_READ_UNCOMMITTED = "read_uncommitted";

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public boolean supportsDropIfExistsSyntax() {
        return false;
    }

    @Override
    public List<Attribute> getColumnMetaDataImpl(CachedDatabaseHandler handler, String from) throws SQLException, OperatorException {
        String sqlQuery = "SELECT TOP 0 * FROM " + from;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        try (QueryRunner qR = this.createQueryRunner(handler);){
            qR.executeQuery(sqlQuery).createExampleTable(null).build().getAttributes().allAttributes().forEachRemaining(attrs::add);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return attrs;
    }

    @Override
    public String escapeLikeExpr(String str) {
        return str.replace("%", "[%]").replace("_", "[_]");
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinFullOuterSql());
        res.put(Sort.class, new SortMSSql());
        res.put(Sample.class, new SampleMSSql());
        res.put(AggregationSubquery.class, new AggregationSubqueryMSSql());
        res.put(AbsoluteSample.class, new AbsoluteSampleMSSql());
        res.put(ProbabilitySample.class, new ProbabilitySampleMSSql());
        return res;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("BIGINT", 8);
        res.put("BOOLEAN", 12);
        res.put("CHAR", 12);
        res.put("DATE", 91);
        res.put("DATETIME", 93);
        res.put("DECIMAL", 8);
        res.put("FLOAT", 6);
        res.put("INT", 4);
        res.put("NUMERIC", 2);
        res.put("REAL", 8);
        res.put("SMALLINT", 4);
        res.put("TIMESTAMP", 93);
        res.put("TINYINT", 4);
        res.put("VARCHAR", 12);
        return res;
    }

    @Override
    public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        Map<Filter.FilterCondition, BiFunction<String, String, String>> filterSyntax = DatabaseProvider.super.getFilterSyntax();
        filterSyntax.put(Filter.FilterCondition.MATCHES, (col, val) -> "PATINDEX(" + this.literal((String)val) + ", " + col + ") != 0");
        return filterSyntax;
    }

    @Override
    public String generateCreateTableSql(Table table, DbStep dbStep) {
        return String.format(TEMPLATE_SELECT_INTO, table.toSql(this), dbStep.toSql(this), this.quote("t1"));
    }

    @Override
    public String insertIntoTableSql(Table table, DbStep dbStep) {
        return String.format(TEMPLATE_INSERT_INTO, table.toSql(this), dbStep.toSql(this));
    }

    @Override
    public boolean supportsRegexpInReplace() {
        return false;
    }

    @Override
    public String generateReplaceExpr(String column, String replaceWhat, String replaceBy) {
        return String.format("REPLACE(%s, %s, %s)", this.quote(column), this.literal(replaceWhat), this.literal(replaceBy));
    }

    @Override
    public QueryRunner createQueryRunner(CachedDatabaseHandler handler) throws SQLException {
        Operator nest = handler.getOperator();
        Objects.requireNonNull(nest, "Nest not found when creating query runner.");
        return new ConfigurableConnectionJdbcQueryRunner(handler, connection -> {
            if (nest.getParameterAsBoolean(PARAMETER_READ_UNCOMMITTED)) {
                connection.setTransactionIsolation(1);
            }
        });
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = DatabaseProvider.super.getParameterTypes();
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_READ_UNCOMMITTED, "Set this to true to use Read Uncommitted Isolation Level. Equivalent to using WITH (NOLOCK) in each query. Please refer to your database documentation for more information.", false, true));
        return types;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 10, "jdbc:sqlserver:", "jdbc:jtds:sqlserver:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("APPROX_COUNT_DISTINCT", "approx count (distinct rows)", "Returns the approximate number of unique non-null values.", 3), new FunctionDefinition("AVG", "average", "Return the average value of the argument.", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "Return the average of the distinct values of the argument.", -1000), new FunctionDefinition("CHECKSUM_AGG", "checksum", "Returns the checksum of all argument values as int.", 3), new FunctionDefinition("CHECKSUM_AGG(DISTINCT)", "checksum (distinct rows)", "Returns the checksum of all distinct argument values as int.", 3), new FunctionDefinition("COUNT", "count", "Return a count of the number of rows returned.", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "Return the count of a number of different values.", 3), new FunctionDefinition("COUNT_BIG", "count bigint", "Return a count of the number of rows returned as bigint.", 4), new FunctionDefinition("COUNT_BIG(DISTINCT)", "count bigint (distinct rows)", "Return the count of a number of different values as bigint.", 4), new FunctionDefinition("MAX", "maximum", "Return the maximum value.", -1000), new FunctionDefinition("MIN", "minimum", "Return the minimum value.", -1000), new FunctionDefinition("STDEVP", "standard deviation", "Return the population standard deviation.", -1000), new FunctionDefinition("STDEV", "sample standard deviation", "Return the sample standard deviation.", -1000), new FunctionDefinition("SUM", "sum", "Return the sum.", -1000), new FunctionDefinition("VARP", "variance", "Return the population standard variance.", -1000), new FunctionDefinition("VAR", "sample variance", "Return the sample variance.", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

