/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.mysql;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.mysql.JoinMySql;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.ParameterService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public enum MySQLProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "mysql";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;
    private static final Set<String> SYSTEM_SCHEMAS;

    @Override
    public List<String> getSchemaNames(CachedDatabaseHandler handler) throws SQLException {
        ArrayList<String> schemaList = new ArrayList<String>();
        String sqlQuery = "SHOW DATABASES;";
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();
             Statement st = dbHandler.createStatement(false, false);
             ResultSet rs = st.executeQuery(sqlQuery);){
            while (rs.next()) {
                String schema = rs.getString(1);
                if (SYSTEM_SCHEMAS.contains(schema.toLowerCase())) continue;
                schemaList.add(schema);
            }
        }
        return DbTools.sortedList(schemaList);
    }

    @Override
    public List<String> getTableNames(CachedDatabaseHandler handler, String schemaName) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        Object sqlQuery = String.format("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = %s", this.literal(schemaName));
        if (Boolean.parseBoolean(ParameterService.getParameterValue((String)"rapidminer.tools.db.assist.show_only_standard_tables"))) {
            sqlQuery = (String)sqlQuery + String.format(" AND TABLE_TYPE = %s", this.literal("BASE TABLE"));
        }
        LOGGER.fine(() -> String.format("Finding tables in schema '%s'", schemaName));
        try (QueryRunner qR = this.createQueryRunner(handler);){
            ExampleSet resultEs = qR.executeQuery((String)sqlQuery).createExampleTable(null).build();
            Attribute onlyAttr = (Attribute)resultEs.getAttributes().allAttributes().next();
            resultEs.forEach(e -> tableList.add(e.getNominalValue(onlyAttr)));
        }
        catch (OperatorException e2) {
            throw new SQLException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
        }
        LOGGER.fine(() -> String.format("Done finding tables in schema '%s'", schemaName));
        return DbTools.sortedList(tableList);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public boolean supportsInfinity() {
        return false;
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinMySql());
        return res;
    }

    @Override
    public String getEnclosingCharacter() {
        return "`";
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("BINARY", 12);
        res.put("CHAR", 12);
        res.put("DATE", 91);
        res.put("DATETIME", 93);
        res.put("DECIMAL", 2);
        res.put("DOUBLE", 8);
        res.put("FLOAT", 6);
        res.put("NUMERIC", 2);
        res.put("REAL", 6);
        res.put("SIGNED INTEGER", 8);
        res.put("TIME", 92);
        res.put("UNSIGNED INTEGER", 8);
        return res;
    }

    @Override
    public boolean supportsRandomSeed() {
        return true;
    }

    @Override
    public int getRankFunctionReturnType() {
        return 7;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        SYSTEM_SCHEMAS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("information_schema", "sys", PROVIDER_ID, "performance_schema")));
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 10, "jdbc:mysql:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("AVG", "average", "Return the average value of the argument.", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "Return the average of the distinct values of the argument.", -1000), new FunctionDefinition("BIT_AND", "bitwise and", "Return bitwise AND.", -1000), new FunctionDefinition("BIT_OR", "bitwise or", "\tReturn bitwise OR.", -1000), new FunctionDefinition("BIT_XOR", "bitwise xor", "Return bitwise XOR.", -1000), new FunctionDefinition("COUNT", "count", "Return a count of the number of rows returned.", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "Return the count of a number of different values.", 3), new FunctionDefinition("GROUP_CONCAT", "group concat", "Return a concatenated string.", 5), new FunctionDefinition("JSON_ARRAYAGG", "JSON array", "Return result set as a single JSON array.", 5), new FunctionDefinition("MAX", "maximum", "Return the maximum value.", -1000), new FunctionDefinition("MIN", "minimum", "Return the minimum value.", -1000), new FunctionDefinition("STD", "standard deviation", "Return the population standard deviation.", -1000), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "Return the sample standard deviation.", -1000), new FunctionDefinition("SUM", "sum", "Return the sum.", -1000), new FunctionDefinition("VAR_POP", "variance", "Return the population standard variance.", -1000), new FunctionDefinition("VAR_SAMP", "sample variance", "Return the sample variance.", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

