/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.oracle;

import com.rapidminer.example.Attribute;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.AbsoluteSample;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.ProbabilitySample;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.oracle.AbsoluteSampleOracleSql;
import com.rapidminer.extension.indatabase.sql.oracle.ProbabilitySampleOracleSql;
import com.rapidminer.extension.indatabase.sql.oracle.SampleOracleSql;
import com.rapidminer.extension.indatabase.sql.shared.JoinFullOuterSql;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.ParameterService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public enum OracleProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "oracle";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public List<String> getTableNames(CachedDatabaseHandler handler, String schemaName) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        boolean onlyStandardTables = Boolean.parseBoolean(ParameterService.getParameterValue((String)"rapidminer.tools.db.assist.show_only_standard_tables"));
        String sqlQuery = "SELECT object_name FROM all_objects WHERE owner = ? AND OBJECT_TYPE IN (%s)";
        sqlQuery = onlyStandardTables ? String.format(sqlQuery, this.literal("TABLE")) : String.format(sqlQuery, this.literal("TABLE") + ", " + this.literal("VIEW"));
        LOGGER.fine(() -> String.format("Finding tables in schema '%s'", schemaName));
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();
             PreparedStatement st = dbHandler.createPreparedStatement(sqlQuery, false);){
            st.setString(1, schemaName);
            try (ResultSet rs = st.executeQuery();){
                while (rs.next()) {
                    tableList.add(rs.getString(1));
                }
            }
        }
        LOGGER.fine(() -> String.format("Done finding tables in schema '%s'", schemaName));
        return DbTools.sortedList(tableList);
    }

    @Override
    public List<Attribute> getColumnMetaDataImpl(CachedDatabaseHandler handler, String from) throws SQLException, OperatorException {
        String sqlQuery = "SELECT * FROM " + from + " WHERE 0=1";
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        try (QueryRunner queryRunner = this.createQueryRunner(handler);){
            queryRunner.executeQuery(sqlQuery).createExampleTable(null).build().getAttributes().allAttributes().forEachRemaining(attrs::add);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return attrs;
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinFullOuterSql());
        res.put(Sample.class, new SampleOracleSql());
        res.put(AbsoluteSample.class, new AbsoluteSampleOracleSql());
        res.put(ProbabilitySample.class, new ProbabilitySampleOracleSql());
        return res;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("CHAR(500)", 12);
        res.put("DATE", 91);
        res.put("DATETIME", 93);
        res.put("FLOAT", 6);
        res.put("INTEGER", 4);
        res.put("NUMERIC", 2);
        res.put("REAL", 8);
        res.put("SMALLINT", 4);
        res.put("TIMESTAMP", 93);
        res.put("VARCHAR(1000)", 12);
        res.put("VARCHAR2(1000)", 12);
        return res;
    }

    @Override
    public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        Map<Filter.FilterCondition, BiFunction<String, String, String>> res = DatabaseProvider.super.getFilterSyntax();
        res.put(Filter.FilterCondition.CONTAINS, (col, val) -> col + " LIKE " + this.literal("%" + this.escapeLikeExpr((String)val) + "%") + " ESCAPE '\\'");
        res.put(Filter.FilterCondition.DOES_NOT_CONTAIN, (col, val) -> col + " NOT LIKE " + this.literal("%" + this.escapeLikeExpr((String)val) + "%") + " ESCAPE '\\'");
        res.put(Filter.FilterCondition.STARTS_WITH, (col, val) -> col + " LIKE " + this.literal(this.escapeLikeExpr((String)val) + "%") + " ESCAPE '\\'");
        res.put(Filter.FilterCondition.ENDS_WITH, (col, val) -> col + " LIKE " + this.literal("%" + this.escapeLikeExpr((String)val)) + " ESCAPE '\\'");
        res.put(Filter.FilterCondition.MATCHES, (col, val) -> "REGEXP_LIKE(" + col + ", " + this.literal("^" + val + "$") + ")");
        return res;
    }

    @Override
    public boolean supportsDropIfExistsSyntax() {
        return false;
    }

    @Override
    public String format(String val, Column c) {
        int type;
        if (!this.isLiteral((String)val) && Ontology.ATTRIBUTE_VALUE_TYPE.isA(type = DbMetaDataTools.getRapidMinerTypeIndex(c.getType()), 9) && !((String)val).trim().startsWith("TO_DATE")) {
            String dateStr = this.literal(DbTools.defaultFormat((String)val, type));
            String dateFormatOracle = Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 10) ? "YYYY-MM-DD" : (Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 11) ? "hh24:mi:ss" : "YYYY-MM-DD hh24:mi:ss");
            val = "TO_DATE(" + dateStr + ", '" + dateFormatOracle + "')";
        }
        return val;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 10, "jdbc:oracle:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("APPROX_COUNT_DISTINCT", "approx count distinct", "APPROX_COUNT_DISTINCT returns the approximate number of rows that contain a distinct value for expr", 2), new FunctionDefinition("APPROX_COUNT_DISTINCT_AGG", "approx count distinct agg", "APPROX_COUNT_DISTINCT_AGG takes as its input a column of details containing information about approximate distinct value counts, and enables you to perform aggregations of those counts", 2), new FunctionDefinition("APPROX_COUNT_DISTINCT_DETAIL", "approx count distinct detail", "APPROX_COUNT_DISTINCT_DETAIL calculates information about the approximate number of rows that contain a distinct value for expr and returns a BLOB value, called a detail, which contains that information in a special format", 2), new FunctionDefinition("APPROX_MEDIAN", "approx median", "APPROX_MEDIAN is an approximate inverse distribution function that assumes a continuous distribution model", 2), new FunctionDefinition("APPROX_PERCENTILE", "approx percentile", "APPROX_PERCENTILE is an approximate inverse distribution function", 2), new FunctionDefinition("APPROX_PERCENTILE_AGG", "approx percentile agg", "APPROX_PERCENTILE_AGG takes as its input a column of details containing approximate percentile information, and enables you to perform aggregations of that information", 2), new FunctionDefinition("APPROX_PERCENTILE_DETAIL", "approx percentile detail", "APPROX_PERCENTILE_DETAIL calculates approximate percentile information for the values of expr and returns a BLOB value, called a detail, which contains that information in a special format", 2), new FunctionDefinition("AVG", "average", "AVG returns average value of expr", 2), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "AVG(DISTINCT) returns average value of distinct expr", 2), new FunctionDefinition("COLLECT", "collect", "COLLECT is an aggregate function that takes as its argument a column of any type and creates a nested table of the input type out of the rows selected", -1000), new FunctionDefinition("CORR", "corr", "CORR returns the coefficient of correlation of a set of number pairs", 2), new FunctionDefinition("COUNT", "count", "COUNT returns the number of rows returned by the query", 2), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "COUNT(DISTINCT) returns the number of distinct rows returned by the query", 2), new FunctionDefinition("COVAR_POP", "covar pop", "COVAR_POP returns the population covariance of a set of number pairs", 2), new FunctionDefinition("COVAR_SAMP", "covar samp", "COVAR_SAMP returns the sample covariance of a set of number pairs", 2), new FunctionDefinition("CUME_DIST", "cume dist", "CUME_DIST calculates the cumulative distribution of a value in a group of values", 2), new FunctionDefinition("DENSE_RANK", "dense rank", "DENSE_RANK computes the rank of a row in an ordered group of rows and returns the rank as a NUMBER", 2), new FunctionDefinition("FIRST", "first", "FIRST and LAST are very similar functions", -1000), new FunctionDefinition("GROUP_ID", "group id", "GROUP_ID distinguishes duplicate groups resulting from a GROUP BY specification", -1000), new FunctionDefinition("GROUPING", "grouping", "GROUPING distinguishes superaggregate rows from regular grouped rows", -1000), new FunctionDefinition("GROUPING_ID", "grouping id", "GROUPING_ID returns a number corresponding to the GROUPING bit vector associated with a row", -1000), new FunctionDefinition("JSON_ARRAYAGG", "json arrayagg", "The SQL/JSON function JSON_ARRAYAGG is an aggregate function", -1000), new FunctionDefinition("JSON_OBJECTAGG", "json objectagg", "The SQL/JSON function JSON_OBJECTAGG is an aggregate function", -1000), new FunctionDefinition("LAST", "last", "FIRST and LAST are very similar functions", -1000), new FunctionDefinition("LISTAGG", "listagg", "For a specified measure, LISTAGG orders data within each group specified in the ORDER BY clause and then concatenates the values of the measure column", -1000), new FunctionDefinition("MAX", "maximum", "MAX returns maximum value of expr", -1000), new FunctionDefinition("MEDIAN", "median", "MEDIAN is an inverse distribution function that assumes a continuous distribution model", -1000), new FunctionDefinition("MIN", "minimum", "MIN returns minimum value of expr", -1000), new FunctionDefinition("PERCENT_RANK", "percent rank", "PERCENT_RANK is similar to the CUME_DIST (cumulative distribution) function", 2), new FunctionDefinition("PERCENTILE_CONT", "percentile cont", "PERCENTILE_CONT is an inverse distribution function that assumes a continuous distribution model", 2), new FunctionDefinition("PERCENTILE_DISC", "percentile disc", "PERCENTILE_DISC is an inverse distribution function that assumes a discrete distribution model", 2), new FunctionDefinition("RANK", "rank", "RANK calculates the rank of a value in a group of values", 2), new FunctionDefinition("STATS_BINOMIAL_TEST", "stats binomial test", "STATS_BINOMIAL_TEST is an exact probability test used for dichotomous variables, where only two possible values exist", -1000), new FunctionDefinition("STATS_CROSSTAB", "stats crosstab", "Crosstabulation (commonly called crosstab) is a method used to analyze two nominal variables", -1000), new FunctionDefinition("STATS_F_TEST", "stats f test", "STATS_F_TEST tests whether two variances are significantly different", -1000), new FunctionDefinition("STATS_KS_TEST", "stats ks test", "STATS_KS_TEST is a Kolmogorov-Smirnov function that compares two samples to test whether they are from the same population or from populations that have the same distribution", -1000), new FunctionDefinition("STATS_MODE", "stats mode", "STATS_MODE takes as its argument a set of values and returns the value that occurs with the greatest frequency", -1000), new FunctionDefinition("STATS_MW_TEST", "stats mw test", "A Mann Whitney test compares two independent samples to test the null hypothesis that two populations have the same distribution function against the alternative hypothesis that the two distribution functions are different", -1000), new FunctionDefinition("STATS_ONE_WAY_ANOVA", "stats one way anova", "The one-way analysis of variance function (STATS_ONE_WAY_ANOVA) tests differences in means (for groups or variables) for statistical significance by comparing two different estimates of variance", -1000), new FunctionDefinition("STATS_WSR_TEST", "stats wsr test", "STATS_WSR_TEST is a Wilcoxon Signed Ranks test of paired samples to determine whether the median of the differences between the samples is significantly different from zero", -1000), new FunctionDefinition("STDDEV", "standard deviation", "STDDEV returns the sample standard deviation of expr, a set of numbers", 2), new FunctionDefinition("STDDEV_POP", "population standard deviation", "STDDEV_POP computes the population standard deviation and returns the square root of the population variance", 2), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "STDDEV_SAMP computes the cumulative sample standard deviation and returns the square root of the sample variance", 2), new FunctionDefinition("SUM", "sum", "SUM returns the sum of values of expr", 2), new FunctionDefinition("SYS_OP_ZONE_ID", "sys op zone id", "SYS_OP_ZONE_ID takes as its argument a rowid and returns a zone ID", -1000), new FunctionDefinition("SYS_XMLAGG", "sys xmlagg", "SYS_XMLAgg aggregates all of the XML documents or fragments represented by expr and produces a single XML document", -1000), new FunctionDefinition("TO_APPROX_COUNT_DISTINCT", "to approx count distinct", "TO_APPROX_COUNT_DISTINCT takes as its input a detail containing information about an approximate distinct value count, and converts it to a NUMBER value", 2), new FunctionDefinition("TO_APPROX_PERCENTILE", "to approx percentile", "TO_APPROX_PERCENTILE takes as its input a detail containing approximate percentile information, a percentile value, and a sort specification, and returns an approximate interpolated value that would fall into that percentile value with respect to the sort specification", 2), new FunctionDefinition("VAR_POP", "population variance", "VAR_POP returns the population variance of a set of numbers after discarding the nulls in this set", 2), new FunctionDefinition("VAR_SAMP", "sample variance", "VAR_SAMP returns the sample variance of a set of numbers after discarding the nulls in this set", 2), new FunctionDefinition("VARIANCE", "variance", "VARIANCE returns the variance of expr", 2), new FunctionDefinition("XMLAGG", "xmlagg", "XMLAgg is an aggregate function", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

