/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.other;

import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;

public enum GenericProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "other";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 100, ""));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("AVG", "average", "Return the average value of the argument.", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "Return the average of the distinct values of the argument.", -1000), new FunctionDefinition("COUNT", "count", "Return a count of the number of rows returned.", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "Return the count of a number of different values.", 3), new FunctionDefinition("MAX", "maximum", "Return the maximum value.", -1000), new FunctionDefinition("MIN", "minimum", "Return the minimum value.", -1000), new FunctionDefinition("STDDEV_POP", "standard deviation", "Return the population standard deviation.", -1000), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "Return the sample standard deviation.", -1000), new FunctionDefinition("SUM", "sum", "Return the sum.", -1000), new FunctionDefinition("VAR_POP", "variance", "Return the population standard variance.", -1000), new FunctionDefinition("VAR_SAMP", "sample variance", "Return the sample variance.", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

