/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.postgresql;

import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.ProbabilitySample;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.postgresql.ProbabilitySamplePostgreSql;
import com.rapidminer.extension.indatabase.sql.shared.JoinFullOuterSql;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Stream;

public enum PostgreSQLProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "postgresql";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;
    public static final Logger LOGGER;

    @Override
    public List<String> getSchemaNames(CachedDatabaseHandler handler) throws SQLException {
        ArrayList<String> schemaList = new ArrayList<String>();
        String sqlQuery = "SELECT schema_name FROM information_schema.schemata WHERE schema_name NOT IN ('pg_catalog', 'information_schema')";
        LOGGER.fine("Finding shemas");
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();
             Statement st = dbHandler.createStatement(false, false);
             ResultSet rs = st.executeQuery(sqlQuery);){
            while (rs.next()) {
                schemaList.add(rs.getString(1));
            }
        }
        LOGGER.fine("Done finding shemas");
        return DbTools.sortedList(schemaList);
    }

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinFullOuterSql());
        res.put(ProbabilitySample.class, new ProbabilitySamplePostgreSql());
        return res;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("BIGINT", 8);
        res.put("BOOLEAN", 12);
        res.put("DATE", 91);
        res.put("DOUBLE PRECISION", 8);
        res.put("INTEGER", 4);
        res.put("NUMERIC", 2);
        res.put("REAL", 8);
        res.put("SMALLINT", 4);
        res.put("TEXT", 12);
        res.put("TIME", 92);
        res.put("TIMESTAMP", 93);
        return res;
    }

    @Override
    public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        Map<Filter.FilterCondition, BiFunction<String, String, String>> filterSyntax = DatabaseProvider.super.getFilterSyntax();
        filterSyntax.put(Filter.FilterCondition.MATCHES, (col, val) -> col + " SIMILAR TO " + this.literal((String)val));
        return filterSyntax;
    }

    @Override
    public int getRankFunctionReturnType() {
        return 7;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 60, "jdbc:postgresql:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("ARRAY_AGG", "concatenate (into array)", "input values, including nulls, concatenated into an array", 5), new FunctionDefinition("AVG", "average", "the average (arithmetic mean) of all input values", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "the average of the distinct values of the argument.", -1000), new FunctionDefinition("BIT_AND", "bitwise and", "the bitwise AND of all non-null input values, or null if none", -1000), new FunctionDefinition("BIT_OR", "bitwise or", "the bitwise OR of all non-null input values, or null if none", -1000), new FunctionDefinition("BOOL_AND", "logical and", "true if all input values are true, otherwise false", 6), new FunctionDefinition("BOOL_OR", "logical or", "true if at least one input value is true, otherwise false", 6), new FunctionDefinition("COUNT", "count", "number of input rows", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "the count of a number of different values.", 3), new FunctionDefinition("EVERY", "every", "equivalent to bool_and", 6), new FunctionDefinition("JSON_AGG", "concatenate (into JSON)", "aggregates values as a JSON array", 5), new FunctionDefinition("MAX", "maximum", "maximum value of expression across all input values", -1000), new FunctionDefinition("MIN", "minimum", "minimum value of expression across all input values", -1000), new FunctionDefinition("STRING_AGG", "concatenate (into Postrge string)", "input values concatenated into a string, separated by delimiter", 5), new FunctionDefinition("SUM", "sum", "sum of expression across all input values", -1000), new FunctionDefinition("XMLAGG", "concatenate (into XML)", "concatenation of XML values", 5), new FunctionDefinition("STDDEV_POP", "standard deviation", "population standard deviation of the input values", -1000), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "sample standard deviation of the input values", -1000), new FunctionDefinition("VAR_POP", "variance", "population variance of the input values (square of the population standard deviation)", -1000), new FunctionDefinition("VAR_SAMP", "sample variance", "sample variance of the input values (square of the sample standard deviation)", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
        LOGGER = Logger.getLogger(PostgreSQLProvider.class.getName());
    }
}

