/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.provider.snowflake;

import com.google.api.client.util.Strings;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.CachedDatabaseHandler;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.db.step.ProbabilitySample;
import com.rapidminer.extension.indatabase.operator.function.FunctionDefinition;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.extension.indatabase.sql.shared.JoinFullOuterSql;
import com.rapidminer.extension.indatabase.sql.snowflake.ProbabilitySampleSnowflakeSql;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.OperatorException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public enum SnowflakeProvider implements DatabaseProvider
{
    INSTANCE;

    private static final String PROVIDER_ID = "snowflake";
    private static final Map<String, FunctionDefinition> AGGREGATEFUNCTIONS;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public Map<String, FunctionDefinition> getAggregationFunctions() {
        return AGGREGATEFUNCTIONS;
    }

    @Override
    public boolean supportsProjects() {
        return true;
    }

    @Override
    public List<String> getProjectNames(CachedDatabaseHandler handler) throws SQLException {
        ArrayList<String> dbList = new ArrayList<String>();
        String sqlQuery = "SHOW DATABASES";
        LOGGER.fine("Finding databases");
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();
             Statement st = dbHandler.createStatement(false, false);
             ResultSet rs = st.executeQuery(sqlQuery);){
            while (rs.next()) {
                dbList.add(rs.getString(2));
            }
        }
        LOGGER.fine("Done finding databases");
        return DbTools.sortedList(dbList);
    }

    @Override
    public List<String> getSchemaNames(CachedDatabaseHandler handler, String projectName) throws SQLException {
        if (Strings.isNullOrEmpty((String)projectName)) {
            return this.getSchemaNames(handler);
        }
        ArrayList<String> schemas = new ArrayList<String>();
        String sqlQuery = "SHOW SCHEMAS IN " + this.quote(projectName);
        LOGGER.fine(() -> String.format("Finding shemas in '%s'", projectName));
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();
             Statement st = dbHandler.createStatement(false, false);
             ResultSet rs = st.executeQuery(sqlQuery);){
            while (rs.next()) {
                schemas.add(rs.getString(2));
            }
        }
        LOGGER.fine(() -> String.format("Done finding shemas in '%s'", projectName));
        return DbTools.sortedList(schemas);
    }

    @Override
    public List<String> getTableNames(CachedDatabaseHandler handler, String projectName, String schemaName) throws SQLException, OperatorException {
        if (Strings.isNullOrEmpty((String)projectName)) {
            return this.getSchemaNames(handler);
        }
        ArrayList<String> schemas = new ArrayList<String>();
        String sqlQuery = String.format("SHOW TABLES IN %s.%s", this.quote(projectName), this.quote(schemaName));
        LOGGER.fine(() -> String.format("Finding tables in schema '%s'.'%s'", projectName, schemaName));
        try (DatabaseHandler dbHandler = handler.getConnectedDatabaseHandler();
             Statement st = dbHandler.createStatement(false, false);
             ResultSet rs = st.executeQuery(sqlQuery);){
            while (rs.next()) {
                schemas.add(rs.getString(2));
            }
        }
        LOGGER.fine(() -> String.format("Done finding tables in schema '%s'.'%s'", projectName, schemaName));
        return DbTools.sortedList(schemas);
    }

    @Override
    public String escapeLiteral(String val) {
        return val.replace(this.getLiteralEnclosingCharacter(), "\\" + this.getLiteralEnclosingCharacter());
    }

    @Override
    public String escapeLikeExpr(String str) {
        return str.replace("%", "\\\\%").replace("_", "\\\\_");
    }

    @Override
    public Map<Filter.FilterCondition, BiFunction<String, String, String>> getFilterSyntax() {
        Map<Filter.FilterCondition, BiFunction<String, String, String>> res = DatabaseProvider.super.getFilterSyntax();
        res.put(Filter.FilterCondition.CONTAINS, (col, val) -> col + " LIKE " + this.literal("%" + this.escapeLikeExpr((String)val) + "%") + " ESCAPE '\\\\'");
        res.put(Filter.FilterCondition.DOES_NOT_CONTAIN, (col, val) -> col + " NOT LIKE " + this.literal("%" + this.escapeLikeExpr((String)val) + "%") + " ESCAPE '\\\\'");
        res.put(Filter.FilterCondition.STARTS_WITH, (col, val) -> col + " LIKE " + this.literal(this.escapeLikeExpr((String)val) + "%") + " ESCAPE '\\\\'");
        res.put(Filter.FilterCondition.ENDS_WITH, (col, val) -> col + " LIKE " + this.literal("%" + this.escapeLikeExpr((String)val)) + " ESCAPE '\\\\'");
        res.put(Filter.FilterCondition.MATCHES, (col, val) -> "REGEXP_LIKE(" + col + ", " + this.literal((String)val) + ")");
        return res;
    }

    @Override
    public Map<Class<? extends DbStep>, SqlSyntax<?>> getDbStepToSyntaxMap() {
        Map<Class<DbStep>, SqlSyntax<?>> res = DatabaseProvider.super.getDbStepToSyntaxMap();
        res.put(Join.class, new JoinFullOuterSql());
        res.put(ProbabilitySample.class, new ProbabilitySampleSnowflakeSql());
        return res;
    }

    @Override
    public boolean supportsRandomSeed() {
        return true;
    }

    @Override
    public Map<String, Integer> getDataTypeSuggestions() {
        LinkedHashMap<String, Integer> res = new LinkedHashMap<String, Integer>();
        res.put("BIGINT", 8);
        res.put("BOOLEAN", 12);
        res.put("DATE", 91);
        res.put("DATETIME", 93);
        res.put("DECIMAL", 8);
        res.put("DOUBLE PRECISION", 8);
        res.put("FLOAT", 8);
        res.put("INTEGER", 8);
        res.put("NUMERIC", 2);
        res.put("REAL", 8);
        res.put("SMALLINT", 8);
        res.put("STRING", 12);
        res.put("TEXT", 12);
        res.put("TIME", 92);
        res.put("TIMESTAMP", 93);
        res.put("TINYINT", 8);
        res.put("VARCHAR", 12);
        return res;
    }

    static {
        AGGREGATEFUNCTIONS = new LinkedHashMap<String, FunctionDefinition>();
        DatabaseProviderFactory.registerProvider(new DatabaseProviderFactory.DatabaseProviderDescriptor(INSTANCE, 80, "", "jdbc:snowflake:"));
        FunctionDefinition[] fs = new FunctionDefinition[]{new FunctionDefinition("AVG", "average", "Return the average value of the argument.", -1000), new FunctionDefinition("AVG(DISTINCT)", "average (distinct rows)", "Return the average of the distinct values of the argument.", -1000), new FunctionDefinition("COUNT", "count", "Return a count of the number of rows returned.", 3), new FunctionDefinition("COUNT(DISTINCT)", "count (distinct rows)", "Return the count of a number of different values.", 3), new FunctionDefinition("MAX", "maximum", "Return the maximum value.", -1000), new FunctionDefinition("MIN", "minimum", "Return the minimum value.", -1000), new FunctionDefinition("STDDEV_POP", "standard deviation", "Return the population standard deviation.", -1000), new FunctionDefinition("STDDEV_SAMP", "sample standard deviation", "Return the sample standard deviation.", -1000), new FunctionDefinition("SUM", "sum", "Return the sum.", -1000), new FunctionDefinition("VAR_POP", "variance", "Return the population standard variance.", -1000), new FunctionDefinition("VAR_SAMP", "sample variance", "Return the sample variance.", -1000)};
        Stream.of(fs).forEachOrdered(f -> AGGREGATEFUNCTIONS.put(f.getName(), (FunctionDefinition)f));
    }
}

