/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.quickfix;

import com.rapidminer.extension.indatabase.OperatorMap;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.flow.processrendering.annotations.model.OperatorAnnotation;
import com.rapidminer.gui.flow.processrendering.annotations.model.WorkflowAnnotation;
import com.rapidminer.gui.flow.processrendering.model.ProcessRendererModel;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.PortOwner;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.container.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class ReplaceWithIndatabaseOperator
extends AbstractQuickFix {
    private Operator operator;
    private Operator replacementOperator;

    public ReplaceWithIndatabaseOperator(Operator op) {
        super(5, false, "replace_non_indb_operator", new Object[]{ReplaceWithIndatabaseOperator.getOfferedIndatabaseOperatorName(op)});
        this.operator = op;
        this.replacementOperator = null;
    }

    private static Object getOfferedIndatabaseOperatorName(Operator op) {
        Class<? extends Operator> offered = OperatorMap.getIndatabaseOperatorFor(op);
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(offered);
        return descriptions.length > 0 ? descriptions[0].getName() : offered.getSimpleName();
    }

    protected Operator getReplacedOperator() {
        return this.operator;
    }

    protected Operator getReplacementOperator() {
        return this.replacementOperator;
    }

    protected void createReplacementOperator() {
        ExecutionUnit process = this.operator.getExecutionUnit();
        if (process != null) {
            HashMap<String, String> parameterStrs = new HashMap<String, String>();
            Parameters parameters = this.operator.getParameters();
            for (Object key : parameters.getKeys()) {
                if (!parameters.isSpecified((String)key)) continue;
                try {
                    parameterStrs.put((String)key, parameters.getParameter((String)key));
                }
                catch (UndefinedParameterError undefinedParameterError) {}
            }
            Class<? extends Operator> indbOpClass = OperatorMap.getIndatabaseOperatorFor(this.operator);
            try {
                this.replacementOperator = OperatorService.createOperator(indbOpClass);
                for (Map.Entry entry : parameterStrs.entrySet()) {
                    String parameterName = (String)entry.getKey();
                    if (!this.replacementOperator.getParameters().getKeys().contains(parameterName)) continue;
                    this.replacementOperator.setParameter(parameterName, (String)entry.getValue());
                }
            }
            catch (OperatorCreationException e) {
                this.operator.logError(e.toString());
            }
        }
    }

    protected void replaceOperators() {
        if (this.replacementOperator == null) {
            return;
        }
        ExecutionUnit process = this.operator.getExecutionUnit();
        if (process != null) {
            Actions actions;
            LinkedHashMap<String, Pair> inputs = new LinkedHashMap<String, Pair>();
            for (Object inputPort : this.operator.getInputPorts().getAllPorts()) {
                if (!inputPort.isConnected()) continue;
                OutputPort out = inputPort.getSource();
                inputs.put(inputPort.getName(), new Pair((Object)out.getPorts().getOwner(), (Object)out.getName()));
            }
            LinkedHashMap<String, Pair> outputs = new LinkedHashMap<String, Pair>();
            for (Object outputPort : this.operator.getOutputPorts().getAllPorts()) {
                if (!outputPort.isConnected()) continue;
                InputPort inputPort = outputPort.getDestination();
                outputs.put(outputPort.getName(), new Pair((Object)inputPort.getPorts().getOwner(), (Object)inputPort.getName()));
            }
            this.operator.remove();
            Operator indbOp = this.replacementOperator;
            process.addOperator(indbOp);
            for (Map.Entry entry : inputs.entrySet()) {
                if (!Arrays.asList(indbOp.getInputPorts().getPortNames()).contains(entry.getKey())) continue;
                ((OutputPort)((PortOwner)((Pair)entry.getValue()).getFirst()).getOperator().getOutputPorts().getPortByName((String)((Pair)entry.getValue()).getSecond())).connectTo((InputPort)indbOp.getInputPorts().getPortByName((String)entry.getKey()));
            }
            for (Map.Entry entry : outputs.entrySet()) {
                if (!Arrays.asList(indbOp.getOutputPorts().getPortNames()).contains(entry.getKey())) continue;
                ((OutputPort)indbOp.getOutputPorts().getPortByName((String)entry.getKey())).connectTo((InputPort)((PortOwner)((Pair)entry.getValue()).getFirst()).getOperator().getInputPorts().getPortByName((String)((Pair)entry.getValue()).getSecond()));
            }
            ProcessRendererModel renderModel = RapidMinerGUI.getMainFrame().getProcessPanel().getProcessRenderer().getModel();
            if (renderModel.getSelectedOperators().contains(this.operator)) {
                renderModel.removeOperatorFromSelection(this.operator);
                renderModel.addOperatorToSelection(indbOp);
                ArrayList<Operator> arrayList = new ArrayList<Operator>();
                arrayList.add(indbOp);
                RapidMinerGUI.getMainFrame().getPropertyPanel().setSelection(arrayList);
            }
            if ((actions = RapidMinerGUI.getMainFrame().getActions()).getSelectedOperators().contains(this.operator)) {
                actions.getSelectedOperators().remove(this.operator);
                actions.getSelectedOperators().add(indbOp);
            }
            renderModel.setOperatorRect(indbOp, renderModel.getOperatorRect(this.operator));
            if (renderModel.getOperatorAnnotations(this.operator) != null) {
                ArrayList originalAnnotations = new ArrayList(renderModel.getOperatorAnnotations(this.operator).getAnnotationsDrawOrder());
                for (WorkflowAnnotation annotation : originalAnnotations) {
                    if (!(annotation instanceof OperatorAnnotation)) continue;
                    ((OperatorAnnotation)annotation).setAttachedTo(indbOp);
                    renderModel.addOperatorAnnotation((OperatorAnnotation)annotation);
                }
            }
        }
    }

    protected void applyInGUIThread() {
        this.createReplacementOperator();
        this.replaceOperators();
    }

    public void apply() {
        if (!OperatorMap.canConvertToIndatabase(this.operator)) {
            this.operator.logError(I18N.getErrorMessage((String)"process.error.replacequickfix.cant_apply_quickfix", (Object[])new Object[]{this.operator.getClass().getCanonicalName()}));
        }
        SwingUtilities.invokeLater(this::applyInGUIThread);
    }
}

