/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.quickfix;

import com.rapidminer.extension.indatabase.OperatorMap;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.Actions;
import com.rapidminer.gui.flow.processrendering.annotations.model.OperatorAnnotation;
import com.rapidminer.gui.flow.processrendering.annotations.model.WorkflowAnnotation;
import com.rapidminer.gui.flow.processrendering.model.ProcessRendererModel;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.ports.quickfix.AbstractQuickFix;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.OperatorService;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ReplaceWithStandardOperator
extends AbstractQuickFix {
    private Operator operator;

    public ReplaceWithStandardOperator(Operator op) {
        super(5, false, "replace_indb_operator", new Object[]{ReplaceWithStandardOperator.getOfferedStandardOperatorName(op)});
        this.operator = op;
    }

    private static Object getOfferedStandardOperatorName(Operator op) {
        Class<? extends Operator> offered = OperatorMap.getStandardOperatorFor(op);
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(offered);
        return descriptions.length > 0 ? descriptions[0].getName() : offered.getSimpleName();
    }

    public void apply() {
        if (!OperatorMap.canConvertToStandard(this.operator)) {
            this.operator.logError(I18N.getErrorMessage((String)"process.error.replacequickfix.cant_apply_quickfix", (Object[])new Object[]{this.operator.getClass().getCanonicalName()}));
        }
        SwingUtilities.invokeLater(() -> {
            ExecutionUnit process = this.operator.getExecutionUnit();
            if (process != null) {
                this.operator.remove();
                Class<? extends Operator> indbOpClass = OperatorMap.getStandardOperatorFor(this.operator);
                try {
                    Actions actions;
                    Operator indbOp = OperatorService.createOperator(indbOpClass);
                    process.addOperator(indbOp);
                    ProcessRendererModel renderModel = RapidMinerGUI.getMainFrame().getProcessPanel().getProcessRenderer().getModel();
                    if (renderModel.getSelectedOperators().contains(this.operator)) {
                        renderModel.removeOperatorFromSelection(this.operator);
                        renderModel.addOperatorToSelection(indbOp);
                        ArrayList<Operator> newOperatorList = new ArrayList<Operator>();
                        newOperatorList.add(indbOp);
                        RapidMinerGUI.getMainFrame().getPropertyPanel().setSelection(newOperatorList);
                    }
                    if ((actions = RapidMinerGUI.getMainFrame().getActions()).getSelectedOperators().contains(this.operator)) {
                        actions.getSelectedOperators().remove(this.operator);
                        actions.getSelectedOperators().add(indbOp);
                    }
                    renderModel.setOperatorRect(indbOp, renderModel.getOperatorRect(this.operator));
                    if (renderModel.getOperatorAnnotations(this.operator) != null) {
                        ArrayList originalAnnotations = new ArrayList(renderModel.getOperatorAnnotations(this.operator).getAnnotationsDrawOrder());
                        for (WorkflowAnnotation annotation : originalAnnotations) {
                            if (!(annotation instanceof OperatorAnnotation)) continue;
                            ((OperatorAnnotation)annotation).setAttachedTo(indbOp);
                            renderModel.addOperatorAnnotation((OperatorAnnotation)annotation);
                        }
                    }
                }
                catch (OperatorCreationException e) {
                    this.operator.logError(e.toString());
                }
            }
        });
    }
}

