/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.sql;

import com.rapidminer.extension.indatabase.db.object.Expression;
import com.rapidminer.extension.indatabase.db.step.Filter;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class FilterAnsiSql
implements SqlSyntax<Filter> {
    private static final String TEMPLATE = "SELECT %s FROM (%s) %s WHERE %s";

    @Override
    public String toSql(DatabaseProvider provider, Filter filter) {
        return String.format(TEMPLATE, filter.getColumnList(provider), filter.getFrom().toSql(provider), provider.quote("t1"), this.buildWhereExpression(provider, filter));
    }

    protected String buildWhereExpression(DatabaseProvider provider, Filter filter) {
        Expression expr = filter.getWhere();
        if (expr != null) {
            return expr.toSql(provider);
        }
        Map<Filter.FilterCondition, BiFunction<String, String, String>> filterSyntax = provider.getFilterSyntax();
        return filter.getFilters().stream().map(r -> (String)((BiFunction)filterSyntax.get((Object)r.getCondition())).apply(r.getColumn().toSql(provider), this.formatFilterValue(provider, (Filter.FilterRow)r))).collect(Collectors.joining(filter.isAnd() ? " AND " : " OR "));
    }

    private String formatFilterValue(DatabaseProvider provider, Filter.FilterRow row) {
        return provider.format(row.getValue(), row.getColumn());
    }
}

