/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.sql;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.Join;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import com.rapidminer.tools.container.Pair;
import java.util.List;
import java.util.stream.Collectors;

public class JoinAnsiSql
implements SqlSyntax<Join> {
    private static final String TEMPLATE = "SELECT %s FROM (%s) %s %s (%s) %s ON %s";

    @Override
    public String toSql(DatabaseProvider provider, Join join) {
        return String.format(TEMPLATE, join.getColumnList(provider), join.getLeft().toSql(provider), provider.quote("t1"), this.buildJoinTypeExpression(join), join.getRight().toSql(provider), provider.quote("t2"), this.buildKeyExpression(provider, join.getKeys()));
    }

    protected String buildJoinTypeExpression(Join join) {
        return String.format("%s JOIN", join.getType().toString());
    }

    protected String buildKeyExpression(DatabaseProvider provider, List<Pair<Column, Column>> keys) {
        return keys.stream().map(e -> String.format("%s = %s", ((Column)e.getFirst()).toSql(provider), ((Column)e.getSecond()).toSql(provider))).collect(Collectors.joining(" AND "));
    }
}

