/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.sql;

import com.rapidminer.extension.indatabase.db.step.Sort;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SortAnsiSql
implements SqlSyntax<Sort> {
    private static final String TEMPLATE = "SELECT * FROM (%s) %s ORDER BY %s";
    private static final Function<Sort.SortType, String> MAP_TYPE = t -> t == Sort.SortType.ASCENDING ? "ASC" : "DESC";

    @Override
    public String toSql(DatabaseProvider provider, Sort sort) {
        return String.format(TEMPLATE, sort.getFrom().toSql(provider), provider.quote("t1"), SortAnsiSql.buildOrderByExpression(provider, sort.getBy()));
    }

    public static String buildOrderByExpression(DatabaseProvider provider, List<Sort.SortColumn> byCols) {
        return byCols.stream().map(c -> String.format("%s %s", c.getColumn().toSql(provider), MAP_TYPE.apply(c.getType()))).collect(Collectors.joining(", "));
    }
}

