/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.sql.oracle;

import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.sql.SqlSyntax;

public class SampleOracleSql
implements SqlSyntax<Sample> {
    private static final String TEMPLATE = "SELECT %s FROM (SELECT %s, ROWNUM %s FROM (%s) %s WHERE ROWNUM <= %d) %s WHERE %s > %d";

    @Override
    public String toSql(DatabaseProvider provider, Sample sample) {
        String columns = sample.getColumnList(provider);
        String rownumAlias = DbTools.newUniqueAlias(sample.getColumns(provider), "rownumalias");
        return String.format(TEMPLATE, columns, columns, rownumAlias, sample.getFrom().toSql(provider), provider.quote("t1"), sample.getLimit() + sample.getOffset(), provider.quote("t1"), rownumAlias, sample.getOffset());
    }
}

