/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client;

import com.rapidminer.extension.insightshub.client.BaseInsightsClient;
import com.rapidminer.extension.insightshub.client.exception.ApiExceptionMapper;
import com.rapidminer.extension.insightshub.client.exception.EntityType;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.client.exception.InsightsNotFoundException;
import com.rapidminer.extension.insightshub.connection.InsightsCredentials;
import com.rapidminer.extension.insightshub.generated.api.assets.AspecttypeApi;
import com.rapidminer.extension.insightshub.generated.api.assets.AssetsApi;
import com.rapidminer.extension.insightshub.generated.api.assets.AssettypeApi;
import com.rapidminer.extension.insightshub.generated.api.assets.StructureApi;
import com.rapidminer.extension.insightshub.generated.api.assets.invoker.ApiClient;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AspectListResource;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AspectTypeResource;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetListResource;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetResource;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetResourceWithHierarchyPath;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeListResource;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeResource;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeResourceAllOfAspects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import okhttp3.OkHttpClient;

public class AssetClient
extends BaseInsightsClient {
    private static final Logger log = Logger.getLogger(AssetClient.class.getName());
    private static final Pattern INSIGHTS_ID_PATTERN = Pattern.compile("^[a-f0-9]{32}$");
    private final AssetsApi assetsApi;
    private final AssettypeApi assettypeApi;
    private final AspecttypeApi aspecttypeApi;
    private final StructureApi structureApi;

    public AssetClient(String accessToken) {
        super(accessToken);
        OkHttpClient httpClient = this.createHttpClientWithLogging();
        ApiClient apiClient = this.configureApiClient(new ApiClient(httpClient));
        this.assetsApi = new AssetsApi(apiClient);
        this.assettypeApi = new AssettypeApi(apiClient);
        this.aspecttypeApi = new AspecttypeApi(apiClient);
        this.structureApi = new StructureApi(apiClient);
    }

    public AssetClient(InsightsCredentials credentials) throws InsightsClientException {
        this(AssetClient.acquireToken(credentials));
    }

    public static boolean isInsightsId(String id) {
        return id != null && INSIGHTS_ID_PATTERN.matcher(id).matches();
    }

    private static InsightsClientException handleApiException(Exception e, EntityType entityType, String entityId) {
        if (ApiExceptionMapper.getStatusCode(e) == 404) {
            return new InsightsNotFoundException(entityType, entityId, e);
        }
        return ApiExceptionMapper.map(e);
    }

    public AssetTypeResourceAllOfAspects getAssetTypeResourceAspect(String assetId, String aspectName) throws InsightsClientException {
        log.fine(() -> String.format("Asset type aspect: assetId='%s', aspect='%s'", assetId, aspectName));
        List<AssetTypeResourceAllOfAspects> allAspects = this.getAllAssetTypeResourceAspects(assetId);
        for (AssetTypeResourceAllOfAspects aspect : allAspects) {
            if (!aspectName.equals(aspect.getName())) continue;
            return aspect;
        }
        throw new InsightsNotFoundException(EntityType.ASPECT, aspectName + " in asset " + assetId);
    }

    public List<AssetTypeResourceAllOfAspects> getAllAssetTypeResourceAspects(String assetId) throws InsightsClientException {
        AssetTypeResource assetTypeResource;
        AssetResourceWithHierarchyPath asset;
        log.fine(() -> String.format("Asset type aspects: assetId='%s'", assetId));
        try {
            long startTime = System.currentTimeMillis();
            asset = this.assetsApi.getAsset(assetId, null, false);
            log.fine(() -> String.format("AssetsApi.getAsset took %dms", System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            throw AssetClient.handleApiException(e, EntityType.ASSET, assetId);
        }
        if (asset == null) {
            throw new InsightsNotFoundException(EntityType.ASSET, assetId);
        }
        log.fine(() -> String.format("AssetsApi.getAsset entity: id='%s', name='%s', typeId='%s'", asset.getAssetId(), asset.getName(), asset.getTypeId()));
        String assetTypeId = asset.getTypeId();
        if (assetTypeId == null || assetTypeId.isEmpty()) {
            throw new InsightsNotFoundException("Asset has no type ID: " + assetId);
        }
        try {
            long startTime = System.currentTimeMillis();
            assetTypeResource = this.assettypeApi.getAssetType(assetTypeId, null, true, false);
            log.fine(() -> String.format("AssettypeApi.getAssetType took %dms", System.currentTimeMillis() - startTime));
        }
        catch (Exception e) {
            throw AssetClient.handleApiException(e, EntityType.ASSET_TYPE, assetTypeId);
        }
        if (assetTypeResource == null) {
            throw new InsightsNotFoundException(EntityType.ASSET_TYPE, assetTypeId);
        }
        log.fine(() -> String.format("AssettypeApi.getAssetType entity: id='%s', name='%s'", assetTypeResource.getId(), assetTypeResource.getName()));
        List aspects = Optional.ofNullable(assetTypeResource.getAspects()).orElse(new ArrayList());
        log.fine(() -> String.format("AssettypeApi.getAssetType aspects: %d", aspects.size()));
        return aspects;
    }

    public List<AssetResource> getAllAssets() throws InsightsClientException {
        log.fine(() -> "Assets: list all");
        try {
            ArrayList<AssetResource> allAssets = new ArrayList<AssetResource>();
            int pageSize = 64;
            int currentPage = 0;
            boolean hasMorePages = true;
            while (hasMorePages) {
                long startTime = System.currentTimeMillis();
                AssetListResource response = this.assetsApi.listAssets(currentPage, pageSize, null, null, null, false, false);
                log.fine(() -> String.format("AssetsApi.listAssets took %dms", System.currentTimeMillis() - startTime));
                if (response.getEmbedded() != null && response.getEmbedded().getAssets() != null) {
                    allAssets.addAll(response.getEmbedded().getAssets());
                }
                if (response.getPage() != null) {
                    hasMorePages = currentPage + 1 < response.getPage().getTotalPages();
                    ++currentPage;
                    continue;
                }
                hasMorePages = false;
            }
            log.fine(() -> String.format("AssetsApi.listAssets size: %d", allAssets.size()));
            return allAssets;
        }
        catch (Exception e) {
            throw ApiExceptionMapper.map(e);
        }
    }

    public List<AssetTypeResource> getAllAssetTypes() throws InsightsClientException {
        String tenantId = this.getTenant();
        log.fine(() -> String.format("Asset types: tenant='%s'", tenantId));
        String filter = null;
        if (tenantId != null && !tenantId.isEmpty()) {
            filter = String.format("{\"tenantId\":{\"eq\":\"%s\"}}", tenantId);
        }
        String finalFilter = filter;
        try {
            ArrayList<AssetTypeResource> allAssetTypes = new ArrayList<AssetTypeResource>();
            int pageSize = 64;
            int currentPage = 0;
            boolean hasMorePages = true;
            while (hasMorePages) {
                long startTime = System.currentTimeMillis();
                AssetTypeListResource response = this.assettypeApi.listAssetTypes(currentPage, pageSize, null, finalFilter, null, true, false);
                log.fine(() -> String.format("AssettypeApi.listAssetTypes took %dms", System.currentTimeMillis() - startTime));
                if (response.getEmbedded() != null && response.getEmbedded().getAssetTypes() != null) {
                    allAssetTypes.addAll(response.getEmbedded().getAssetTypes());
                }
                if (response.getPage() != null) {
                    hasMorePages = currentPage + 1 < response.getPage().getTotalPages();
                    ++currentPage;
                    continue;
                }
                hasMorePages = false;
            }
            log.fine(() -> String.format("AssettypeApi.listAssetTypes size: %d", allAssetTypes.size()));
            return allAssetTypes;
        }
        catch (Exception e) {
            throw ApiExceptionMapper.map(e);
        }
    }

    public List<AssetResource> getAssetsByType(String typeId) throws InsightsClientException {
        log.fine(() -> String.format("Assets by type: typeId='%s'", typeId));
        String filter = "{\"typeId\":{\"eq\":\"" + typeId + "\"}}";
        try {
            ArrayList<AssetResource> matchingAssets = new ArrayList<AssetResource>();
            int pageSize = 64;
            int currentPage = 0;
            boolean hasMorePages = true;
            while (hasMorePages) {
                long startTime = System.currentTimeMillis();
                AssetListResource response = this.assetsApi.listAssets(currentPage, pageSize, null, filter, null, false, false);
                log.fine(() -> String.format("AssetsApi.listAssets took %dms", System.currentTimeMillis() - startTime));
                if (response.getEmbedded() != null && response.getEmbedded().getAssets() != null) {
                    matchingAssets.addAll(response.getEmbedded().getAssets());
                }
                if (response.getPage() != null) {
                    hasMorePages = currentPage + 1 < response.getPage().getTotalPages();
                    ++currentPage;
                    continue;
                }
                hasMorePages = false;
            }
            log.fine(() -> String.format("AssetsApi.listAssets size: %d", matchingAssets.size()));
            return matchingAssets;
        }
        catch (Exception e) {
            throw AssetClient.handleApiException(e, EntityType.ASSET_TYPE, typeId);
        }
    }

    public String getAssetId(String assetName) throws InsightsClientException {
        log.fine(() -> String.format("Asset id for name: %s", assetName));
        String filter = String.format("{\"name\":{\"eq\":\"%s\"}}", assetName);
        try {
            AssetListResource response = this.assetsApi.listAssets(0, 1, null, filter, null, false, false);
            if (response.getEmbedded() != null && response.getEmbedded().getAssets() != null && !response.getEmbedded().getAssets().isEmpty()) {
                return response.getEmbedded().getAssets().get(0).getAssetId();
            }
            return null;
        }
        catch (Exception e) {
            throw AssetClient.handleApiException(e, EntityType.ASSET, assetName);
        }
    }

    public String getAspectName(String assetId, String aspectId) throws InsightsClientException {
        log.fine(() -> String.format("Aspect name: assetId='%s', aspectId='%s'", assetId, aspectId));
        List<AssetTypeResourceAllOfAspects> aspects = this.getAllAssetTypeResourceAspects(assetId);
        for (AssetTypeResourceAllOfAspects aspect : aspects) {
            if (!aspectId.equals(aspect.getAspectId())) continue;
            return aspect.getName();
        }
        return null;
    }

    public AspectListResource getAssetAspects(String assetId) throws InsightsClientException {
        return this.getAssetAspects(assetId, null);
    }

    public AspectListResource getAssetAspects(String assetId, String filter) throws InsightsClientException {
        log.fine(() -> String.format("Aspects for asset: %s, filter: %s", assetId, filter));
        try {
            long startTime = System.currentTimeMillis();
            AspectListResource response = this.structureApi.listAssetAspects(assetId, null, null, null, filter, null, false);
            log.fine(() -> String.format("StructureApi.listAssetAspects took %dms", System.currentTimeMillis() - startTime));
            if (response == null) {
                throw new InsightsNotFoundException(EntityType.ASPECTS, assetId);
            }
            log.fine(() -> String.format("Aspects for asset %s: found %d", assetId, response.getEmbedded() != null && response.getEmbedded().getAspects() != null ? response.getEmbedded().getAspects().size() : 0));
            return response;
        }
        catch (Exception e) {
            throw AssetClient.handleApiException(e, EntityType.ASSET, assetId);
        }
    }

    public AspectTypeResource getAspectType(String aspectId) throws InsightsClientException {
        log.fine(() -> String.format("Aspect type: aspectId='%s'", aspectId));
        try {
            long startTime = System.currentTimeMillis();
            AspectTypeResource response = this.aspecttypeApi.getAspectType(aspectId, null, false);
            log.fine(() -> String.format("AspecttypeApi.getAspectType took %dms", System.currentTimeMillis() - startTime));
            if (response == null) {
                throw new InsightsNotFoundException(EntityType.ASPECT_TYPE, aspectId);
            }
            log.fine(() -> String.format("AspecttypeApi.getAspectType entity: id='%s', name='%s'", response.getId(), response.getName()));
            return response;
        }
        catch (Exception e) {
            throw AssetClient.handleApiException(e, EntityType.ASPECT_TYPE, aspectId);
        }
    }
}

