/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client;

import com.rapidminer.extension.insightshub.client.OkHttpClientFactory;
import com.rapidminer.extension.insightshub.client.TokenClient;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.connection.InsightsCredentials;
import com.rapidminer.extension.insightshub.util.InsightsTools;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;

public abstract class BaseInsightsClient {
    private static final Logger log = Logger.getLogger(BaseInsightsClient.class.getName());
    protected final String accessToken;
    protected final String tenant;

    protected BaseInsightsClient(String accessToken) {
        if (accessToken == null || accessToken.trim().isEmpty()) {
            throw new IllegalArgumentException("Access token cannot be null or empty");
        }
        this.accessToken = accessToken;
        this.tenant = InsightsTools.extractTenantFromJWT(accessToken);
    }

    public String getTenant() {
        return this.tenant;
    }

    protected String getAccessToken() {
        return this.accessToken;
    }

    protected static String acquireToken(InsightsCredentials credentials) throws InsightsClientException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials cannot be null");
        }
        return TokenClient.acquireAccessToken(credentials.getTenant(), credentials.getUsername(), credentials.getPassword());
    }

    protected static String getGatewayBasePath(String gatewayUrl, String basePath) {
        if (gatewayUrl.endsWith("/")) {
            return gatewayUrl + (basePath.startsWith("/") ? basePath.substring(1) : basePath);
        }
        return gatewayUrl + (String)(basePath.startsWith("/") ? basePath : "/" + basePath);
    }

    protected OkHttpClient createHttpClient() {
        return OkHttpClientFactory.create();
    }

    protected OkHttpClient createHttpClientWithLogging() {
        return OkHttpClientFactory.createWithLogging();
    }

    protected <T> T configureApiClient(T apiClient) {
        try {
            Method getBasePathMethod = apiClient.getClass().getMethod("getBasePath", new Class[0]);
            Method setBasePathMethod = apiClient.getClass().getMethod("setBasePath", String.class);
            Method addDefaultHeaderMethod = apiClient.getClass().getMethod("addDefaultHeader", String.class, String.class);
            String basePath = (String)getBasePathMethod.invoke(apiClient, new Object[0]);
            String fullPath = BaseInsightsClient.getGatewayBasePath(InsightsTools.getGatewayUrl(), basePath);
            setBasePathMethod.invoke(apiClient, fullPath);
            addDefaultHeaderMethod.invoke(apiClient, "Authorization", "Bearer " + this.accessToken);
            log.fine(() -> String.format("Configured API client with base path: %s", fullPath));
            return apiClient;
        }
        catch (Exception e) {
            log.severe(() -> String.format("Failed to configure API client: %s", e.getMessage()));
            throw new IllegalStateException("Failed to configure API client: " + e.getMessage(), e);
        }
    }
}

