/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client;

import com.rapidminer.extension.insightshub.client.BaseInsightsClient;
import com.rapidminer.extension.insightshub.client.exception.ApiExceptionMapper;
import com.rapidminer.extension.insightshub.client.exception.EntityType;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.client.exception.InsightsNotFoundException;
import com.rapidminer.extension.insightshub.connection.InsightsCredentials;
import com.rapidminer.extension.insightshub.generated.api.datalake.ObjectAccessOperationsApi;
import com.rapidminer.extension.insightshub.generated.api.datalake.ObjectListOperationsApi;
import com.rapidminer.extension.insightshub.generated.api.datalake.ObjectsMetadataCatalogOperationsApi;
import com.rapidminer.extension.insightshub.generated.api.datalake.invoker.ApiClient;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.GenerateUrlPayload;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ListFilesResponse;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ListFoldersResponse;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ListObjectResource;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ListObjectResponse;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ObjectMetaDataResponse;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.Path;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.SignedUrlResponse;
import com.rapidminer.extension.insightshub.ioobject.DataLakeStreamFileObject;
import com.rapidminer.extension.insightshub.util.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;

public class DataLakeClient
extends BaseInsightsClient {
    private static final Logger log = Logger.getLogger(DataLakeClient.class.getName());
    private final ObjectListOperationsApi listClient;
    private final ObjectAccessOperationsApi accessClient;
    private final ObjectsMetadataCatalogOperationsApi metadataClient;
    private static final Map<String, String> EXTENSION_TO_CONTENT_TYPE = Map.of(".csv", "text/csv", ".json", "application/json", ".xml", "application/xml", ".txt", "text/plain", ".pdf", "application/pdf", ".parquet", "application/octet-stream");

    public DataLakeClient(String accessToken) {
        super(accessToken);
        OkHttpClient httpClient = this.createHttpClient();
        ApiClient apiClient = this.configureApiClient(new ApiClient(httpClient));
        this.listClient = new ObjectListOperationsApi(apiClient);
        this.accessClient = new ObjectAccessOperationsApi(apiClient);
        this.metadataClient = new ObjectsMetadataCatalogOperationsApi(apiClient);
    }

    public DataLakeClient(InsightsCredentials credentials) throws InsightsClientException {
        this(DataLakeClient.acquireToken(credentials));
    }

    public List<ListFilesResponse> listFiles(String path, String subtenantId) throws InsightsClientException {
        ListObjectResource response;
        String cleaned;
        log.fine(() -> String.format("Listing files in path: %s", path));
        String apiPath = path == null || path.trim().isEmpty() ? "/" : ((cleaned = this.stripStoragePrefix(path)) == null || cleaned.trim().isEmpty() ? "/" : (cleaned.startsWith("/") ? cleaned.substring(1) : cleaned));
        String finalApiPath = apiPath;
        try {
            response = this.listClient.listObjects(finalApiPath, null, null, subtenantId);
        }
        catch (Exception e) {
            throw ApiExceptionMapper.map(e);
        }
        ArrayList<ListFilesResponse> result = new ArrayList<ListFilesResponse>();
        if (response != null && response.getObjects() != null) {
            ListObjectResponse obj = response.getObjects();
            result.addAll(obj.getFiles());
            for (ListFoldersResponse folder : obj.getFolders()) {
                ListFilesResponse pseudo = new ListFilesResponse();
                Object folderKey = folder.getKey();
                if (!((String)folderKey).endsWith("/")) {
                    folderKey = (String)folderKey + "/";
                }
                pseudo.setKey((String)folderKey);
                pseudo.setContentSize(BigDecimal.ZERO);
                result.add(pseudo);
            }
        }
        for (ListFilesResponse r : result) {
            String k;
            String clean;
            if (r == null || (clean = this.stripStoragePrefix(k = r.getKey())) == null || clean.equals(k)) continue;
            r.setKey(clean);
        }
        log.fine(() -> String.format("Found %d entries in path: %s", result.size(), apiPath));
        return result;
    }

    private String stripStoragePrefix(String key) {
        if (key == null) {
            return null;
        }
        String k = key;
        if (k.startsWith("/")) {
            k = k.substring(1);
        }
        if (this.tenant != null && !this.tenant.trim().isEmpty()) {
            String candidate = "data/ten=" + this.tenant + "/";
            if (k.startsWith(candidate)) {
                return k.substring(candidate.length());
            }
            String candidateNoSlash = "data/ten=" + this.tenant;
            if (k.equals(candidateNoSlash)) {
                return "";
            }
            if (k.startsWith(candidateNoSlash + "/")) {
                return k.substring((candidateNoSlash + "/").length());
            }
        }
        return k;
    }

    public ObjectMetaDataResponse getFileMetadata(String path, String subtenantId) throws InsightsClientException {
        log.fine(() -> String.format("Retrieving metadata for file: %s", path));
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("File path cannot be null or empty");
        }
        try {
            ObjectMetaDataResponse metadata = this.metadataClient.retrieveObjectMetadata(path, subtenantId);
            log.fine(() -> String.format("Retrieved metadata for file: %s", path));
            return metadata;
        }
        catch (Exception e) {
            if (ApiExceptionMapper.getStatusCode(e) == 404) {
                throw new InsightsNotFoundException(EntityType.DATA_LAKE_FILE, path, e);
            }
            throw ApiExceptionMapper.map(e);
        }
    }

    public ListFilesResponse getSingleFile(String path, String subtenantId) throws InsightsClientException {
        log.fine(() -> String.format("Getting single file: %s", path));
        List<ListFilesResponse> files = this.listFiles(path, subtenantId);
        for (ListFilesResponse file : files) {
            if (!path.equals(file.getKey())) continue;
            log.fine(() -> String.format("Found file: %s", path));
            return file;
        }
        log.warning(() -> "File not found: " + path);
        return null;
    }

    public File downloadFile(String filePath, String subtenantId) throws InsightsClientException, IOException {
        log.fine(() -> String.format("Downloading file: %s", filePath));
        try (InputStream inputStream2 = this.getFileStream(filePath, subtenantId);){
            String fileName = this.extractFileName(filePath);
            java.nio.file.Path tempFile = Files.createTempFile("datalake_", "_" + fileName, new FileAttribute[0]);
            Files.copy(inputStream2, tempFile, StandardCopyOption.REPLACE_EXISTING);
            File resultFile = tempFile.toFile();
            log.fine(() -> String.format("Successfully downloaded file: %s to temporary location", filePath));
            File file = resultFile;
            return file;
        }
    }

    private String extractFileName(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return "unknown";
        }
        int lastSlash = filePath.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash < filePath.length() - 1) {
            return filePath.substring(lastSlash + 1);
        }
        return filePath;
    }

    public InputStream getFileStream(String filePath, String subtenantId) throws InsightsClientException, IOException {
        SignedUrlResponse urlResponse;
        log.fine(() -> String.format("Getting file stream for: %s", filePath));
        ArrayList<Path> paths = new ArrayList<Path>();
        Path pathObj = new Path();
        pathObj.setPath(filePath);
        paths.add(pathObj);
        GenerateUrlPayload payload = new GenerateUrlPayload();
        payload.setPaths(paths);
        if (subtenantId != null && !subtenantId.trim().isEmpty()) {
            payload.setSubtenantId(subtenantId);
        }
        try {
            urlResponse = this.accessClient.generateDownloadObjectUrls(payload);
        }
        catch (Exception e) {
            if (ApiExceptionMapper.getStatusCode(e) == 404) {
                throw new InsightsNotFoundException(EntityType.DATA_LAKE_FILE, filePath, e);
            }
            throw ApiExceptionMapper.map(e);
        }
        if (urlResponse.getObjectUrls() == null || urlResponse.getObjectUrls().isEmpty()) {
            throw new InsightsNotFoundException(EntityType.DATA_LAKE_FILE, filePath);
        }
        String downloadUrl = urlResponse.getObjectUrls().get(0).getSignedUrl();
        log.fine(() -> String.format("Generated download URL for streaming file: %s", filePath));
        try {
            InputStream stream = new URL(downloadUrl).openStream();
            log.fine(() -> String.format("Successfully opened stream for file: %s", filePath));
            return stream;
        }
        catch (IOException e) {
            log.severe(() -> String.format("Failed to open stream for file: %s", filePath));
            throw e;
        }
    }

    public void uploadFile(String uploadPath, InputStream fileStream, String fileName, String subtenantId) throws InsightsClientException, IOException {
        SignedUrlResponse urlResponse;
        log.fine(() -> String.format("Uploading file to path: %s", uploadPath));
        String normalizedPath = PathUtils.ensureLeadingSlash(uploadPath);
        GenerateUrlPayload payload = new GenerateUrlPayload();
        payload.setPaths(Collections.singletonList(new Path().path(normalizedPath)));
        if (subtenantId != null && !subtenantId.trim().isEmpty()) {
            payload.setSubtenantId(subtenantId);
        }
        try {
            urlResponse = this.accessClient.generateUploadObjectUrls(payload);
        }
        catch (Exception e) {
            throw ApiExceptionMapper.map(e);
        }
        if (urlResponse.getObjectUrls() == null || urlResponse.getObjectUrls().isEmpty()) {
            throw new InsightsNotFoundException("Upload URL could not be generated for path: " + normalizedPath);
        }
        String uploadUrl = urlResponse.getObjectUrls().get(0).getSignedUrl();
        log.fine(() -> String.format("Generated upload URL for path: %s", normalizedPath));
        try {
            this.uploadFileToSignedUrl(uploadUrl, fileStream, fileName);
            log.fine(() -> String.format("Successfully uploaded file to path: %s", normalizedPath));
        }
        catch (IOException e) {
            log.severe(() -> String.format("Failed to upload file to path: %s", uploadPath));
            throw e;
        }
    }

    private void uploadFileToSignedUrl(String signedUrl, InputStream fileStream, String fileName) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(signedUrl).openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        String contentType = this.detectContentType(fileName);
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType);
        }
        try (OutputStream outputStream2 = connection.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = fileStream.read(buffer)) != -1) {
                outputStream2.write(buffer, 0, bytesRead);
            }
        }
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new IOException("Upload failed with response code: " + responseCode + " - " + connection.getResponseMessage());
        }
    }

    private String detectContentType(String fileName) {
        if (fileName == null) {
            return null;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            return "application/octet-stream";
        }
        String extension = fileName.substring(dotIndex).toLowerCase(Locale.ROOT);
        return EXTENSION_TO_CONTENT_TYPE.getOrDefault(extension, "application/octet-stream");
    }

    public List<DataLakeStreamFileObject> discoverImportJobFiles(String destination, String assetId, String aspectId, LocalDate fromDate, LocalDate toDate) {
        ArrayList<DataLakeStreamFileObject> files = new ArrayList<DataLakeStreamFileObject>();
        String basePath = DataLakeClient.buildDataLakeTsiPath(destination, assetId, aspectId);
        try {
            List<ListFilesResponse> entries = this.listFiles(basePath, null);
            for (ListFilesResponse entry : entries) {
                String folderName;
                String key = entry.getKey();
                if (key == null || !DataLakeClient.isDateFormat(folderName = PathUtils.extractLastPathSegment(key))) continue;
                try {
                    LocalDate folderDate = LocalDate.parse(folderName, DateTimeFormatter.ISO_LOCAL_DATE);
                    if (folderDate.isBefore(fromDate) || folderDate.isAfter(toDate)) continue;
                    String filePath = String.format("%s%s/day.parquet", basePath, folderName);
                    try {
                        InputStream stream = this.getFileStream(filePath, null);
                        if (stream == null) continue;
                        files.add(new DataLakeStreamFileObject(filePath, stream));
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e, () -> String.format("File not found or inaccessible: %s", filePath));
                    }
                }
                catch (DateTimeParseException e) {
                    log.fine(() -> String.format("Skipping non-date folder: %s", key));
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> String.format("Failed to list files in %s", basePath));
        }
        return files;
    }

    private static String buildDataLakeTsiPath(String destination, String assetId, String aspectId) {
        String normalizedDestination = PathUtils.trimSlashes(destination);
        if (normalizedDestination.isEmpty()) {
            return String.format("/TSI/%s/%s/", assetId, aspectId);
        }
        return String.format("/TSI/%s/%s/%s/", normalizedDestination, assetId, aspectId);
    }

    private static boolean isDateFormat(String str) {
        if (str == null || str.length() != 10) {
            return false;
        }
        try {
            LocalDate.parse(str, DateTimeFormatter.ISO_LOCAL_DATE);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }
}

