/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public final class OkHttpClientFactory {
    private static final Logger log = Logger.getLogger(OkHttpClientFactory.class.getName());
    private static final ThreadLocal<Boolean> debuggingEnabled = ThreadLocal.withInitial(() -> true);
    private static final int DEFAULT_CONNECT_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_READ_TIMEOUT_SECONDS = 60;
    private static final int DEFAULT_WRITE_TIMEOUT_SECONDS = 60;

    private OkHttpClientFactory() {
    }

    public static void setDebuggingEnabled(boolean enabled) {
        debuggingEnabled.set(enabled);
    }

    public static boolean isDebuggingEnabled() {
        return debuggingEnabled.get();
    }

    public static OkHttpClient create() {
        return OkHttpClientFactory.create(OkHttpClientFactory.isDebuggingEnabled());
    }

    public static OkHttpClient create(boolean withLogging) {
        return OkHttpClientFactory.create(30, 60, 60, withLogging);
    }

    public static OkHttpClient createWithLogging() {
        return OkHttpClientFactory.create(true);
    }

    public static OkHttpClient create(int connectTimeoutSeconds, int readTimeoutSeconds, int writeTimeoutSeconds, boolean withLogging) {
        log.info(() -> String.format("Creating OkHttpClient with logging %s", withLogging ? "ENABLED" : "disabled"));
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(connectTimeoutSeconds, TimeUnit.SECONDS).readTimeout(readTimeoutSeconds, TimeUnit.SECONDS).writeTimeout(writeTimeoutSeconds, TimeUnit.SECONDS);
        if (withLogging) {
            builder.addInterceptor(OkHttpClientFactory.createLoggingInterceptor());
        }
        return builder.build();
    }

    private static HttpLoggingInterceptor createLoggingInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(message -> log.fine(() -> "[okHttp] " + message));
        interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        log.info("HTTP logging interceptor created and configured with BODY level logging");
        return interceptor;
    }
}

