/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client;

import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.rapidminer.extension.insightshub.client.AssetClient;
import com.rapidminer.extension.insightshub.client.BaseInsightsClient;
import com.rapidminer.extension.insightshub.client.exception.ApiExceptionMapper;
import com.rapidminer.extension.insightshub.client.exception.EntityType;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.client.exception.InsightsNotFoundException;
import com.rapidminer.extension.insightshub.client.model.AggregatesV4Response;
import com.rapidminer.extension.insightshub.connection.InsightsCredentials;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AspectListResource;
import com.rapidminer.extension.insightshub.generated.api.datalake.TimeSeriesBulkImportApi;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ImportJobRequest;
import com.rapidminer.extension.insightshub.generated.api.datalake.model.ImportJobResponse;
import com.rapidminer.extension.insightshub.generated.api.timeseries.TimeSeriesOperationsApi;
import com.rapidminer.extension.insightshub.generated.api.timeseries.model.TimeSeriesDataItem;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates4.AggregatesApi;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.ApiException;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.JSON;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates4.model.Variable;
import com.rapidminer.extension.insightshub.generated.api.tsbulk.ReadOperationsApi;
import com.rapidminer.extension.insightshub.generated.api.tsbulk.invoker.ApiClient;
import com.rapidminer.extension.insightshub.generated.api.tsbulk.model.TimeSeries;
import com.rapidminer.extension.insightshub.operator.parameter.ParameterUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TimeSeriesClient
extends BaseInsightsClient {
    private static final Logger log = Logger.getLogger(TimeSeriesClient.class.getName());
    private static final int PAGE_SIZE_DATA = 2000;
    private static final int JOB_STATUS_POLL_INTERVAL_MS = 1000;
    private static final long PAGINATION_TIME_OFFSET_NANOS = 1000000L;
    private final TimeSeriesOperationsApi timeSeriesApi;
    private final ReadOperationsApi bulkReadApi;
    private final AggregatesApi aggregatesV4Api;
    private final TimeSeriesBulkImportApi bulkImportApi;
    private final AssetClient assetClient;
    private final Gson aggregatesV4ResponseReader = JSON.createGson().registerTypeAdapter(java.util.Date.class, (Object)new JSON.DateTypeAdapter()).registerTypeAdapter(Date.class, (Object)new JSON.SqlDateTypeAdapter()).registerTypeAdapter(OffsetDateTime.class, (Object)new JSON.OffsetDateTimeTypeAdapter()).registerTypeAdapter(LocalDate.class, (Object)new JSON.LocalDateTypeAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new Variable.CustomTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new AggregatesV4Response.AggregateIntervalTypeAdapterFactory()).registerTypeAdapterFactory((TypeAdapterFactory)new AggregatesV4Response.CustomTypeAdapterFactory()).create();

    public TimeSeriesClient(String accessToken) {
        super(accessToken);
        OkHttpClient httpClient = this.createHttpClient();
        this.assetClient = new AssetClient(accessToken);
        com.rapidminer.extension.insightshub.generated.api.timeseries.invoker.ApiClient timeSeriesApiClient = new com.rapidminer.extension.insightshub.generated.api.timeseries.invoker.ApiClient(httpClient);
        this.configureApiClient(timeSeriesApiClient);
        this.timeSeriesApi = new TimeSeriesOperationsApi(timeSeriesApiClient);
        ApiClient bulkApiClient = new ApiClient(httpClient);
        this.configureApiClient(bulkApiClient);
        this.bulkReadApi = new ReadOperationsApi(bulkApiClient);
        com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.ApiClient aggregatesV4ApiClient = new com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.ApiClient(httpClient);
        this.configureApiClient(aggregatesV4ApiClient);
        this.aggregatesV4Api = new AggregatesApi(aggregatesV4ApiClient);
        com.rapidminer.extension.insightshub.generated.api.datalake.invoker.ApiClient bulkImportApiClient = new com.rapidminer.extension.insightshub.generated.api.datalake.invoker.ApiClient(httpClient);
        this.configureApiClient(bulkImportApiClient);
        this.bulkImportApi = new TimeSeriesBulkImportApi(bulkImportApiClient);
    }

    public TimeSeriesClient(InsightsCredentials credentials) throws InsightsClientException {
        this(TimeSeriesClient.acquireToken(credentials));
    }

    public List<TimeSeriesDataItem> retrieveTimeSeriesData(String entityId, String propertySetName, String fromIsoInstant, String toIsoInstant, Integer limit, String variables, String sort, Boolean isLatestValue) throws InsightsClientException {
        log.fine(() -> String.format("Retrieving time series data: entityId='%s', propertySet='%s', from='%s', to='%s', limit=%d", entityId, propertySetName, fromIsoInstant, toIsoInstant, limit));
        if (!(limit == null || limit > 2000 || isLatestValue != null && isLatestValue.booleanValue())) {
            return this.retrieveSinglePage(entityId, propertySetName, fromIsoInstant, toIsoInstant, limit, variables, sort, isLatestValue);
        }
        return this.retrieveAllPages(entityId, propertySetName, fromIsoInstant, toIsoInstant, limit, variables, sort, isLatestValue);
    }

    private List<TimeSeriesDataItem> retrieveSinglePage(String entityId, String propertySetName, String fromIsoInstant, String toIsoInstant, Integer limit, String variables, String sort, Boolean isLatestValue) throws InsightsClientException {
        OffsetDateTime from = this.parseIsoInstant(fromIsoInstant);
        OffsetDateTime to = this.parseIsoInstant(toIsoInstant);
        long startTime = System.currentTimeMillis();
        try {
            ArrayList result = this.timeSeriesApi.retrieveTimeseries(entityId, propertySetName, from, to, limit, variables, sort, isLatestValue);
            log.fine(() -> String.format("Insights TimeSeriesOperationsApi.retrieveTimeseries took %dms", System.currentTimeMillis() - startTime));
            if (result != null) {
                log.fine(() -> String.format("Insights TimeSeriesOperationsApi.retrieveTimeseries response size: %d", result.size()));
            }
            return result != null ? result : new ArrayList();
        }
        catch (Exception e) {
            throw this.handleTimeSeriesException(e, entityId, propertySetName);
        }
    }

    private List<TimeSeriesDataItem> retrieveAllPages(String entityId, String propertySetName, String fromIsoInstant, String toIsoInstant, Integer limit, String variables, String sort, Boolean isLatestValue) throws InsightsClientException {
        log.fine(() -> String.format("Retrieving all time series data using pagination: entityId='%s', propertySet='%s', from='%s', to='%s', limit=%d", entityId, propertySetName, fromIsoInstant, toIsoInstant, limit));
        if (isLatestValue != null && isLatestValue.booleanValue()) {
            return this.retrieveSinglePage(entityId, propertySetName, fromIsoInstant, toIsoInstant, limit, variables, sort, isLatestValue);
        }
        long totalStartTime = System.currentTimeMillis();
        OffsetDateTime from = this.parseIsoInstant(fromIsoInstant);
        OffsetDateTime to = this.parseIsoInstant(toIsoInstant);
        ArrayList<TimeSeriesDataItem> result = new ArrayList<TimeSeriesDataItem>();
        int totalItems = 0;
        OffsetDateTime currentFrom = from;
        boolean hasMoreData = true;
        while (hasMoreData && (limit == null || totalItems < limit)) {
            List<TimeSeriesDataItem> pageData;
            int pageLimit = limit != null && limit - totalItems < 2000 ? limit - totalItems : 2000;
            OffsetDateTime pageFrom = currentFrom;
            long pageStartTime = System.currentTimeMillis();
            try {
                pageData = this.timeSeriesApi.retrieveTimeseries(entityId, propertySetName, pageFrom, to, pageLimit, variables, sort, null);
            }
            catch (Exception e) {
                throw this.handleTimeSeriesException(e, entityId, propertySetName);
            }
            log.fine(() -> String.format("Page retrieval took %dms", System.currentTimeMillis() - pageStartTime));
            if (pageData != null && !pageData.isEmpty()) {
                result.addAll(pageData);
                int totalItemsFinal = totalItems += pageData.size();
                log.fine(() -> String.format("Retrieved page with %d items, total so far: %d", pageData.size(), totalItemsFinal));
                if (pageData.size() >= pageLimit) {
                    TimeSeriesDataItem lastItem = pageData.get(pageData.size() - 1);
                    if (lastItem.getTime() != null) {
                        currentFrom = lastItem.getTime().plusNanos(1000000L);
                        continue;
                    }
                    log.warning("Last item in page has null time, cannot continue pagination");
                    hasMoreData = false;
                    continue;
                }
                hasMoreData = false;
                continue;
            }
            hasMoreData = false;
        }
        log.fine(() -> String.format("Insights TimeSeriesOperationsApi total retrieval took %dms, %d total items", System.currentTimeMillis() - totalStartTime, result.size()));
        return result;
    }

    public List<TimeSeriesDataItem> retrieveBulkTimeSeriesData(String entityId, String propertySetName, String fromIsoInstant, String toIsoInstant, Integer limit, String variables) throws InsightsClientException {
        log.fine(() -> String.format("Retrieving bulk time series data: entityId='%s', propertySet='%s', from='%s', to='%s', limit=%d", entityId, propertySetName, fromIsoInstant, toIsoInstant, limit));
        OffsetDateTime from = this.parseIsoInstant(fromIsoInstant);
        OffsetDateTime to = this.parseIsoInstant(toIsoInstant);
        long startTime = System.currentTimeMillis();
        try {
            TimeSeries result = this.bulkReadApi.retrieveTimeseries(entityId, propertySetName, from, to, limit, variables);
            log.fine(() -> String.format("Insights ReadOperationsApi.retrieveTimeseries took %dms", System.currentTimeMillis() - startTime));
            if (result == null || result.getRecords() == null || result.getRecords().isEmpty()) {
                log.fine(() -> "Insights ReadOperationsApi.retrieveTimeseries returned no results");
                return new ArrayList<TimeSeriesDataItem>();
            }
            List<TimeSeriesDataItem> timeSeriesData = this.convertBulkResponseToTimeseries(result);
            log.fine(() -> String.format("Insights ReadOperationsApi.retrieveTimeseries response size: %d", timeSeriesData.size()));
            return timeSeriesData;
        }
        catch (Exception e) {
            throw this.handleTimeSeriesException(e, entityId, propertySetName);
        }
    }

    public AggregatesV4Response retrieveAggregatesV4(String assetId, String aspectName, String from, String to, Integer intervalValue, String intervalUnit, String variables, Integer limit) throws InsightsClientException {
        try {
            return this.retrieveAggregatesV4WithHttpInfo(assetId, aspectName, from, to, intervalValue, intervalUnit, variables, limit);
        }
        catch (Exception e) {
            throw this.handleTimeSeriesException(e, assetId, aspectName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AggregatesV4Response retrieveAggregatesV4WithHttpInfo(String assetId, String aspectName, String from, String to, Integer intervalValue, String intervalUnit, String variables, Integer limit) throws ApiException {
        BigDecimal intervalValueBigDecimal = intervalValue != null ? BigDecimal.valueOf(intervalValue.intValue()) : null;
        String countString = limit != null ? String.valueOf(limit) : null;
        Call call = this.aggregatesV4Api.retrieveAggregatesCall(assetId, aspectName, from, to, intervalValueBigDecimal, intervalUnit, variables, countString, null);
        try (Response response = call.execute();){
            if (!response.isSuccessful()) {
                String errorBody = null;
                ResponseBody body = response.body();
                if (body == null) throw new ApiException(response.message(), response.code(), response.headers().toMultimap(), errorBody);
                errorBody = body.string();
                throw new ApiException(response.message(), response.code(), response.headers().toMultimap(), errorBody);
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                AggregatesV4Response aggregatesV4Response = null;
                return aggregatesV4Response;
            }
            AggregatesV4Response aggregatesV4Response = (AggregatesV4Response)this.aggregatesV4ResponseReader.fromJson((Reader)new StringReader(responseBody.string()), AggregatesV4Response.class);
            return aggregatesV4Response;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private List<TimeSeriesDataItem> convertBulkResponseToTimeseries(TimeSeries bulkResult) {
        ArrayList<TimeSeriesDataItem> timeSeriesData = new ArrayList<TimeSeriesDataItem>();
        if (bulkResult.getRecords() != null) {
            for (Map<String, Object> record : bulkResult.getRecords()) {
                TimeSeriesDataItem item = new TimeSeriesDataItem();
                Object timeValue = record.get("_time");
                if (timeValue != null) {
                    try {
                        OffsetDateTime time = ParameterUtils.toOffsetDateTime(timeValue.toString());
                        item.setTime(time);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, e, () -> String.format("Failed to parse time value: %s", timeValue));
                    }
                }
                for (Map.Entry<String, Object> entry : record.entrySet()) {
                    if ("_time".equals(entry.getKey())) continue;
                    item.putAdditionalProperty(entry.getKey(), entry.getValue());
                }
                timeSeriesData.add(item);
            }
        }
        return timeSeriesData;
    }

    private OffsetDateTime parseIsoInstant(String isoInstant) {
        return ParameterUtils.toOffsetDateTime(isoInstant);
    }

    private void validateAspectExists(String assetId, String propertySetName) throws InsightsClientException {
        String filter = String.format("{\"name\":{\"eq\":\"%s\"}}", propertySetName);
        long startTime = System.currentTimeMillis();
        AspectListResource aspectListResource = this.assetClient.getAssetAspects(assetId, filter);
        log.fine(() -> String.format("AssetClient.getAssetAspects (filtered) took %dms", System.currentTimeMillis() - startTime));
        if (aspectListResource == null || aspectListResource.getEmbedded() == null || aspectListResource.getEmbedded().getAspects() == null || aspectListResource.getEmbedded().getAspects().isEmpty()) {
            throw new InsightsNotFoundException(EntityType.ASPECT, propertySetName + " (for asset: " + assetId + ")");
        }
        log.fine(() -> String.format("Aspect '%s' found for asset '%s'", propertySetName, assetId));
    }

    private InsightsClientException handleTimeSeriesException(Exception e, String entityId, String propertySetName) {
        if (ApiExceptionMapper.getStatusCode(e) == 404) {
            try {
                this.validateAspectExists(entityId, propertySetName);
                return new InsightsNotFoundException(EntityType.TIME_SERIES, entityId + "/" + propertySetName, e);
            }
            catch (InsightsNotFoundException aspectNotFound) {
                return aspectNotFound;
            }
            catch (InsightsClientException validationError) {
                return new InsightsNotFoundException(EntityType.TIME_SERIES, entityId + "/" + propertySetName, e);
            }
        }
        return ApiExceptionMapper.map(e);
    }

    public ImportJobResponse createImportJob(String name, String destination, String subtenantId, List<String> aspectNames, List<String> assetIds, String from, String to) throws InsightsClientException {
        log.fine(() -> String.format("Creating import job '%s': aspects=%s, assets=%s, from='%s', to='%s'", name, aspectNames, assetIds, from, to));
        ImportJobRequest importRequest = new ImportJobRequest();
        importRequest.setName(name);
        importRequest.setDestination(destination);
        importRequest.setAspectNames(aspectNames);
        importRequest.setAssetIds(assetIds);
        importRequest.setFrom(from);
        importRequest.setTo(to);
        if (subtenantId != null && !subtenantId.trim().isEmpty()) {
            importRequest.setSubtenantId(subtenantId);
        }
        try {
            ImportJobResponse result = this.bulkImportApi.createTimeSeriesImportJob(importRequest);
            log.fine(() -> String.format("Import job created with ID: %s", result.getId()));
            return result;
        }
        catch (Exception e) {
            throw ApiExceptionMapper.map(e);
        }
    }

    public ImportJobResponse getJobStatus(String jobId) throws InsightsClientException {
        try {
            return this.bulkImportApi.retrieveTimeSeriesImportJob(jobId);
        }
        catch (Exception e) {
            if (ApiExceptionMapper.getStatusCode(e) == 404) {
                throw new InsightsNotFoundException(EntityType.IMPORT_JOB, jobId, e);
            }
            throw ApiExceptionMapper.map(e);
        }
    }

    public ImportJobResponse.StatusEnum pollJobStatus(String jobId, int timeoutSeconds) throws InsightsClientException {
        if (timeoutSeconds <= 0) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        log.fine(() -> String.format("Polling job status for ID: %s, timeout: %d seconds", jobId, timeoutSeconds));
        long startTime = System.currentTimeMillis();
        long timeoutMillis = (long)timeoutSeconds * 1000L;
        while (System.currentTimeMillis() - startTime < timeoutMillis) {
            ImportJobResponse response = this.getJobStatus(jobId);
            ImportJobResponse.StatusEnum status = response.getStatus();
            log.fine(() -> String.format("Job %s status: %s", new Object[]{jobId, status}));
            if (status == ImportJobResponse.StatusEnum.SUCCESS || status == ImportJobResponse.StatusEnum.FAILED) {
                return status;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InsightsClientException("Job polling interrupted", e);
            }
        }
        ImportJobResponse finalResponse = this.getJobStatus(jobId);
        log.fine(() -> String.format("Job %s polling timeout reached, final status: %s", new Object[]{jobId, finalResponse.getStatus()}));
        return finalResponse.getStatus();
    }
}

