/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client;

import com.rapidminer.extension.insightshub.client.OkHttpClientFactory;
import com.rapidminer.extension.insightshub.client.exception.InsightsAuthenticationException;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.generated.api.oauth.TokenEndpointApi;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiClient;
import com.rapidminer.extension.insightshub.generated.api.oauth.model.AccessTokenResponse;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;

public final class TokenClient {
    private static final Logger log = Logger.getLogger(TokenClient.class.getName());

    private TokenClient() {
    }

    public static String acquireAccessToken(String tenant, String clientId, String clientSecret) throws InsightsClientException {
        try {
            OkHttpClient httpClient = OkHttpClientFactory.create();
            ApiClient apiClient = new ApiClient(httpClient);
            String host = String.format("https://%s.piam.%s.%s", tenant, "eu1", "mindsphere.io");
            apiClient.setBasePath(host);
            apiClient.setUsername(clientId);
            apiClient.setPassword(clientSecret);
            TokenEndpointApi api = new TokenEndpointApi(apiClient);
            AccessTokenResponse resp = api.tokenEndpointPostClientCredentialsGrant("client_credentials", null, null);
            if (resp == null || resp.getAccessToken() == null || resp.getAccessToken().isEmpty()) {
                log.severe(() -> String.format("Failed to acquire access token for tenant %s: empty response", tenant));
                throw new InsightsAuthenticationException(String.format("Failed to acquire access token for tenant %s: empty response", tenant));
            }
            return resp.getAccessToken();
        }
        catch (InsightsClientException e) {
            throw e;
        }
        catch (Exception e) {
            log.severe(() -> String.format("Failed to acquire access token for tenant %s: %s", tenant, e.getMessage()));
            throw new InsightsAuthenticationException(String.format("Failed to acquire access token for tenant %s", tenant), e);
        }
    }
}

