/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client.exception;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.rapidminer.extension.insightshub.client.exception.InsightsAuthenticationException;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.client.exception.InsightsConflictException;
import com.rapidminer.extension.insightshub.client.exception.InsightsNotFoundException;
import com.rapidminer.extension.insightshub.client.exception.InsightsPreconditionFailedException;
import com.rapidminer.extension.insightshub.client.exception.InsightsRateLimitException;
import com.rapidminer.extension.insightshub.client.exception.InsightsServiceException;
import com.rapidminer.extension.insightshub.client.exception.InsightsValidationException;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates.invoker.ApiException;
import java.util.List;
import java.util.Map;

public final class ApiExceptionMapper {
    private static final Gson gson = new Gson();

    private ApiExceptionMapper() {
    }

    public static InsightsClientException map(Exception e) {
        ApiExceptionAdapter a = ApiExceptionAdapter.of(e);
        String message = ApiExceptionMapper.extractErrorMessage(a.getResponseBody(), a.getApiException().getMessage());
        int statusCode = a.getCode();
        return switch (statusCode) {
            case 401, 403 -> new InsightsAuthenticationException(message, e);
            case 404 -> new InsightsNotFoundException(message, e);
            case 400, 406 -> new InsightsValidationException(message, e);
            case 409 -> new InsightsConflictException(message, e);
            case 412 -> new InsightsPreconditionFailedException(message, e);
            case 429 -> new InsightsRateLimitException(message, e);
            case 500, 501, 503 -> new InsightsServiceException(message, e);
            default -> new InsightsServiceException(message, e);
        };
    }

    public static int getStatusCode(Exception e) {
        try {
            ApiExceptionAdapter a = ApiExceptionAdapter.of(e);
            return a.getCode();
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    private static String extractErrorMessage(String responseBody, String fallbackMessage) {
        if (responseBody == null || responseBody.trim().isEmpty()) {
            return fallbackMessage;
        }
        try {
            Map errorMap;
            Object message;
            Object firstError;
            List errorList;
            Object errors;
            Object message2;
            Map body = (Map)gson.fromJson(responseBody, Map.class);
            if (body.containsKey("message") && (message2 = body.get("message")) instanceof String) {
                return (String)message2;
            }
            if (body.containsKey("errors") && (errors = body.get("errors")) instanceof List && !(errorList = (List)errors).isEmpty() && (firstError = errorList.get(0)) instanceof Map && (message = (errorMap = (Map)firstError).get("message")) != null) {
                return message.toString();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return fallbackMessage;
    }

    private static class ApiExceptionAdapter
    extends RuntimeException {
        private final Exception apiException;
        private final int code;
        private final String responseBody;

        private static ApiExceptionAdapter of(Exception e) {
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.timeseries.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.timeseries.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.timeseries.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.datalake.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.datalake.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.datalake.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.assets.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.assets.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.assets.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.tsbulk.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.tsbulk.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.tsbulk.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof ApiException) {
                ApiException ex = (ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.tsaggregates4.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            if (e instanceof com.rapidminer.extension.insightshub.generated.api.tokens.invoker.ApiException) {
                com.rapidminer.extension.insightshub.generated.api.tokens.invoker.ApiException ex = (com.rapidminer.extension.insightshub.generated.api.tokens.invoker.ApiException)e;
                return new ApiExceptionAdapter(ex, ex.getCode(), ex.getResponseBody());
            }
            throw new IllegalArgumentException("Unknown ApiException type: " + e.getClass().getName());
        }

        public Exception getApiException() {
            return this.apiException;
        }

        public int getCode() {
            return this.code;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        public ApiExceptionAdapter(Exception apiException, int code, String responseBody) {
            this.apiException = apiException;
            this.code = code;
            this.responseBody = responseBody;
        }
    }
}

