/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.client.model;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates4.model.Variable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregatesV4Response {
    @SerializedName(value="aggregates")
    private List<AggregateInterval> aggregates;

    public List<AggregateInterval> getAggregates() {
        return this.aggregates;
    }

    public void setAggregates(List<AggregateInterval> aggregates) {
        this.aggregates = aggregates;
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AggregatesV4Response.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return delegate;
        }
    }

    public static class AggregateIntervalTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AggregateInterval.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter variableAdapter = gson.getAdapter(Variable.class);
            TypeAdapter dateTimeAdapter = gson.getAdapter(OffsetDateTime.class);
            return new AggregateIntervalTypeAdapter((TypeAdapter<Variable>)variableAdapter, (TypeAdapter<OffsetDateTime>)dateTimeAdapter);
        }
    }

    static class AggregateIntervalTypeAdapter
    extends TypeAdapter<AggregateInterval> {
        private final TypeAdapter<Variable> variableAdapter;
        private final TypeAdapter<OffsetDateTime> dateTimeAdapter;

        AggregateIntervalTypeAdapter(TypeAdapter<Variable> variableAdapter, TypeAdapter<OffsetDateTime> dateTimeAdapter) {
            this.variableAdapter = variableAdapter;
            this.dateTimeAdapter = dateTimeAdapter;
        }

        public void write(JsonWriter out, AggregateInterval value) throws IOException {
            out.beginObject();
            if (value.getStarttime() != null) {
                out.name("starttime");
                this.dateTimeAdapter.write(out, (Object)value.getStarttime());
            }
            if (value.getEndtime() != null) {
                out.name("endtime");
                this.dateTimeAdapter.write(out, (Object)value.getEndtime());
            }
            if (value.getProperties() != null) {
                for (Map.Entry<String, Variable> entry : value.getProperties().entrySet()) {
                    out.name(entry.getKey());
                    this.variableAdapter.write(out, (Object)entry.getValue());
                }
            }
            out.endObject();
        }

        public AggregateInterval read(JsonReader in) throws IOException {
            AggregateInterval interval = new AggregateInterval();
            interval.setProperties(new HashMap<String, Variable>());
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if ("starttime".equals(name)) {
                    interval.setStarttime(this.readOffsetDateTime(in));
                    continue;
                }
                if ("endtime".equals(name)) {
                    interval.setEndtime(this.readOffsetDateTime(in));
                    continue;
                }
                this.readDynamicProperty(in, name, interval);
            }
            in.endObject();
            return interval;
        }

        private void readDynamicProperty(JsonReader in, String name, AggregateInterval interval) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else if (in.peek() == JsonToken.BEGIN_OBJECT) {
                Variable variable = (Variable)this.variableAdapter.read(in);
                interval.addProperty(name, variable);
            } else {
                in.skipValue();
            }
        }

        private OffsetDateTime readOffsetDateTime(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String timeStr = in.nextString();
            if (timeStr == null || timeStr.isEmpty()) {
                return null;
            }
            try {
                return OffsetDateTime.parse(timeStr, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (Exception e) {
                return OffsetDateTime.parse(timeStr);
            }
        }
    }

    public static class AggregateInterval {
        private OffsetDateTime starttime;
        private OffsetDateTime endtime;
        private Map<String, Variable> properties = new HashMap<String, Variable>();

        public OffsetDateTime getStarttime() {
            return this.starttime;
        }

        public void setStarttime(OffsetDateTime starttime) {
            this.starttime = starttime;
        }

        public OffsetDateTime getEndtime() {
            return this.endtime;
        }

        public void setEndtime(OffsetDateTime endtime) {
            this.endtime = endtime;
        }

        public Map<String, Variable> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Variable> properties) {
            this.properties = properties;
        }

        public void addProperty(String name, Variable variable) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Variable>();
            }
            this.properties.put(name, variable);
        }
    }
}

