/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.connection;

import com.rapidminer.connection.ConnectionHandler;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationBuilder;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.configuration.ConnectionConfiguration;
import com.rapidminer.connection.configuration.ConnectionConfigurationBuilder;
import com.rapidminer.connection.util.ConnectionI18N;
import com.rapidminer.connection.util.ParameterUtility;
import com.rapidminer.connection.util.TestExecutionContext;
import com.rapidminer.connection.util.TestResult;
import com.rapidminer.connection.util.ValidationResult;
import com.rapidminer.extension.insightshub.client.TokenClient;
import com.rapidminer.tools.LogService;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class InsightsConnectionConfigurator
implements ConnectionHandler {
    public static final String TYPE_ID = "cloud-insights";
    public static final String GROUP_BASIC = "basic";
    public static final String PARAMETER_TENANT = "tenant";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";

    public String getType() {
        return TYPE_ID;
    }

    public ConnectionInformation createNewConnectionInformation(String name) {
        ConnectionConfigurationBuilder confBuilder = new ConnectionConfigurationBuilder(name, this.getType());
        confBuilder.withKeys(GROUP_BASIC, Arrays.asList((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_TENANT, (boolean)false).build(), (ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_USERNAME, (boolean)false).build(), (ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_PASSWORD, (boolean)true).build()));
        ConnectionInformationBuilder infoBuilder = new ConnectionInformationBuilder(confBuilder.build());
        return infoBuilder.build();
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public ValidationResult validate(ConnectionInformation connectionInformation) {
        String[] params;
        if (connectionInformation == null) {
            return ValidationResult.nullable();
        }
        ConnectionConfiguration config = connectionInformation.getConfiguration();
        HashMap<CallSite, String> parameterErrors = new HashMap<CallSite, String>();
        for (String param : params = new String[]{PARAMETER_TENANT, PARAMETER_USERNAME, PARAMETER_PASSWORD}) {
            String fullParamKey = "basic." + param;
            String value = this.getParameterValue(config, GROUP_BASIC, param);
            if (value == null || value.trim().isEmpty()) {
                parameterErrors.put((CallSite)((Object)fullParamKey), ConnectionI18N.getValidationErrorMessage((String)"validation.parameter_empty", (String)TYPE_ID, (String)GROUP_BASIC, (String)param));
                continue;
            }
            String trimmedValue = value.trim();
            if (trimmedValue.matches("[a-zA-Z0-9._@-]+")) continue;
            parameterErrors.put((CallSite)((Object)fullParamKey), ConnectionI18N.getValidationErrorMessage((String)"validation.parameter_invalid", (String)TYPE_ID, (String)GROUP_BASIC, (String)param));
        }
        if (!parameterErrors.isEmpty()) {
            return ValidationResult.failure((String)"validation.failed", parameterErrors, (Object[])new Object[0]);
        }
        return ValidationResult.success((String)"validation.success");
    }

    public TestResult test(TestExecutionContext<ConnectionInformation> testContext) {
        if (testContext == null || testContext.getSubject() == null) {
            return TestResult.nullable();
        }
        ValidationResult validation = this.validate((ConnectionInformation)testContext.getSubject());
        if (validation.getType() == TestResult.ResultType.FAILURE) {
            return TestResult.failure((String)validation.getMessageKey(), (Map)validation.getParameterErrorMessages(), (Object[])validation.getArguments());
        }
        ConnectionConfiguration config = ((ConnectionInformation)testContext.getSubject()).getConfiguration();
        try {
            String tenant = this.getParameterValue(config, GROUP_BASIC, PARAMETER_TENANT);
            String username = this.getParameterValue(config, GROUP_BASIC, PARAMETER_USERNAME);
            String password = this.getParameterValue(config, GROUP_BASIC, PARAMETER_PASSWORD);
            if (this.testInsightsConnection(tenant, username, password)) {
                return TestResult.success((String)"test.success");
            }
            LogService.getRoot().log(Level.WARNING, () -> "Connection test for '" + ((ConnectionInformation)testContext.getSubject()).getConfiguration().getName() + "' failed.");
            return TestResult.failure((String)"test.connection_failed", (Object[])new Object[0]);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, e, () -> "Connection test for '" + ((ConnectionInformation)testContext.getSubject()).getConfiguration().getName() + "' failed.");
            return TestResult.failure((String)"test.connection_failed", (Object[])new Object[]{e.getLocalizedMessage()});
        }
    }

    private String getParameterValue(ConnectionConfiguration config, String group, String parameterName) {
        String fullParameterKey = group + "." + parameterName;
        ConfigurationParameter parameter = config.getParameter(fullParameterKey);
        return parameter != null ? parameter.getValue() : null;
    }

    private boolean testInsightsConnection(String tenant, String username, String password) {
        try {
            String accessToken = TokenClient.acquireAccessToken(tenant, username, password);
            return accessToken != null && !accessToken.trim().isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }
}

