/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.data;

import com.rapidminer.belt.table.Builders;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.belt.util.Belt;
import com.rapidminer.extension.insightshub.client.model.AggregatesV4Response;
import com.rapidminer.extension.insightshub.data.BeltTableUtils;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AspectVariable;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeResourceAllOfAspects;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates.model.Aggregate;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates.model.Aggregates;
import com.rapidminer.extension.insightshub.generated.api.tsaggregates4.model.Variable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AggregatesTableBuilder {
    private static final Logger log = Logger.getLogger(AggregatesTableBuilder.class.getName());
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";

    private AggregatesTableBuilder() {
    }

    public static Table buildAggregatesV4Table(AggregatesV4Response aggregatesResponses, AssetTypeResourceAllOfAspects assetTypeResourceAspect) {
        if (aggregatesResponses == null) {
            return AggregatesTableBuilder.createEmptyAggregateTable();
        }
        List<AggregatesV4Response.AggregateInterval> intervalList = aggregatesResponses.getAggregates();
        if (intervalList == null || intervalList.isEmpty()) {
            return AggregatesTableBuilder.createEmptyAggregateTable();
        }
        AggregatesV4Response.AggregateInterval[] intervals = (AggregatesV4Response.AggregateInterval[])intervalList.stream().filter(Objects::nonNull).toArray(AggregatesV4Response.AggregateInterval[]::new);
        if (intervals.length == 0) {
            return AggregatesTableBuilder.createEmptyAggregateTable();
        }
        Map<String, AspectVariable.DataTypeEnum> dataTypeMap = BeltTableUtils.getDataTypeMap(assetTypeResourceAspect);
        int rowCount = intervals.length;
        TableBuilder builder = Builders.newTableBuilder((int)rowCount);
        Instant[] startTimes = new Instant[rowCount];
        Instant[] endTimes = new Instant[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            AggregatesV4Response.AggregateInterval interval = intervals[i2];
            startTimes[i2] = AggregatesTableBuilder.safeToInstant(interval.getStarttime(), STARTTIME);
            endTimes[i2] = AggregatesTableBuilder.safeToInstant(interval.getEndtime(), ENDTIME);
        }
        builder.addDateTime(STARTTIME, i -> startTimes[i]);
        builder.addDateTime(ENDTIME, i -> endTimes[i]);
        Map<String, Variable> properties = intervals[0].getProperties();
        if (properties != null) {
            for (String propertyName : properties.keySet()) {
                AspectVariable.DataTypeEnum dataType = dataTypeMap.get(propertyName);
                AggregatesTableBuilder.addV4AggregateColumns(builder, propertyName, dataType, intervals);
            }
        }
        return builder.build(Belt.defaultContext());
    }

    private static Instant safeToInstant(OffsetDateTime time, String fieldName) {
        if (time == null) {
            return null;
        }
        try {
            return time.toInstant();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> "Failed to parse " + fieldName + ": " + String.valueOf(time));
            return null;
        }
    }

    private static Table createEmptyAggregateTable() {
        TableBuilder builder = Builders.newTableBuilder((int)0);
        builder.addDateTime(STARTTIME, i -> null);
        builder.addDateTime(ENDTIME, i -> null);
        return builder.build(Belt.defaultContext());
    }

    private static void addV4AggregateColumns(TableBuilder builder, String propertyName, AspectVariable.DataTypeEnum dataType, AggregatesV4Response.AggregateInterval[] intervals) {
        boolean useIntegerColumns;
        int rowCount = intervals.length;
        Variable[] variables = new Variable[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            variables[i2] = AggregatesTableBuilder.getV4PropertyVariable(intervals[i2], propertyName);
        }
        IntFunction<Variable> varProvider = i -> variables[i];
        boolean bl = useIntegerColumns = dataType == AspectVariable.DataTypeEnum.INT || dataType == AspectVariable.DataTypeEnum.LONG || dataType == AspectVariable.DataTypeEnum.BOOLEAN;
        if (useIntegerColumns) {
            builder.addInt53Bit(propertyName + "_average", BeltTableUtils.doubleValueFunction(varProvider, Variable::getAverage));
            builder.addInt53Bit(propertyName + "_sum", BeltTableUtils.doubleValueFunction(varProvider, Variable::getSum));
            builder.addInt53Bit(propertyName + "_minvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getMinvalue));
            builder.addInt53Bit(propertyName + "_maxvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getMaxvalue));
            builder.addInt53Bit(propertyName + "_firstvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getFirstvalue));
            builder.addInt53Bit(propertyName + "_lastvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getLastvalue));
        } else {
            builder.addReal(propertyName + "_average", BeltTableUtils.doubleValueFunction(varProvider, Variable::getAverage));
            builder.addReal(propertyName + "_sum", BeltTableUtils.doubleValueFunction(varProvider, Variable::getSum));
            builder.addReal(propertyName + "_minvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getMinvalue));
            builder.addReal(propertyName + "_maxvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getMaxvalue));
            builder.addReal(propertyName + "_firstvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getFirstvalue));
            builder.addReal(propertyName + "_lastvalue", BeltTableUtils.doubleValueFunction(varProvider, Variable::getLastvalue));
        }
        builder.addInt53Bit(propertyName + "_countgood", BeltTableUtils.numberValueFunction(varProvider, Variable::getCountgood));
        builder.addInt53Bit(propertyName + "_countuncertain", BeltTableUtils.numberValueFunction(varProvider, Variable::getCountuncertain));
        builder.addInt53Bit(propertyName + "_countbad", BeltTableUtils.numberValueFunction(varProvider, Variable::getCountbad));
        builder.addDateTime(propertyName + "_mintime", BeltTableUtils.instantValueFunction(varProvider, Variable::getMintime));
        builder.addDateTime(propertyName + "_maxtime", BeltTableUtils.instantValueFunction(varProvider, Variable::getMaxtime));
        builder.addDateTime(propertyName + "_firsttime", BeltTableUtils.instantValueFunction(varProvider, Variable::getFirsttime));
        builder.addDateTime(propertyName + "_lasttime", BeltTableUtils.instantValueFunction(varProvider, Variable::getLasttime));
        builder.addReal(propertyName + "_sd", BeltTableUtils.doubleValueFunction(varProvider, Variable::getSd));
    }

    private static Variable getV4PropertyVariable(AggregatesV4Response.AggregateInterval interval, String propertyName) {
        Map<String, Variable> properties = interval.getProperties();
        return properties != null ? properties.get(propertyName) : null;
    }

    private static void addTimeColumns(TableBuilder builder, List<Aggregates> aggregates) {
        int rowCount = aggregates.size();
        Instant[] startTimes = new Instant[rowCount];
        Instant[] endTimes = new Instant[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Aggregates aggInterval = aggregates.get(i2);
            startTimes[i2] = AggregatesTableBuilder.safeToInstant(aggInterval.getStarttime(), STARTTIME);
            endTimes[i2] = AggregatesTableBuilder.safeToInstant(aggInterval.getEndtime(), ENDTIME);
        }
        builder.addDateTime(STARTTIME, i -> startTimes[i]);
        builder.addDateTime(ENDTIME, i -> endTimes[i]);
    }

    private static void addLegacyAggregateColumns(TableBuilder builder, String fieldName, List<Aggregates> aggregatesList) {
        int rowCount = aggregatesList.size();
        Aggregate[] aggregates = new Aggregate[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Map<String, Object> fields = aggregatesList.get(i2).getAdditionalProperties();
            Object fieldValue = fields != null ? fields.get(fieldName) : null;
            aggregates[i2] = fieldValue instanceof Aggregate ? (Aggregate)fieldValue : null;
        }
        IntFunction<Aggregate> aggProvider = i -> aggregates[i];
        builder.addReal(fieldName + "_average", BeltTableUtils.doubleValueFunction(aggProvider, Aggregate::getAverage));
        builder.addReal(fieldName + "_sum", BeltTableUtils.doubleValueFunction(aggProvider, Aggregate::getSum));
        builder.addReal(fieldName + "_minvalue", BeltTableUtils.doubleValueFunction(aggProvider, Aggregate::getMinvalue));
        builder.addReal(fieldName + "_maxvalue", BeltTableUtils.doubleValueFunction(aggProvider, Aggregate::getMaxvalue));
        builder.addReal(fieldName + "_firstvalue", BeltTableUtils.doubleValueFunction(aggProvider, Aggregate::getFirstvalue));
        builder.addReal(fieldName + "_lastvalue", BeltTableUtils.doubleValueFunction(aggProvider, Aggregate::getLastvalue));
        builder.addInt53Bit(fieldName + "_countgood", BeltTableUtils.numberValueFunction(aggProvider, Aggregate::getCountgood));
        builder.addInt53Bit(fieldName + "_countuncertain", BeltTableUtils.numberValueFunction(aggProvider, Aggregate::getCountuncertain));
        builder.addInt53Bit(fieldName + "_countbad", BeltTableUtils.numberValueFunction(aggProvider, Aggregate::getCountbad));
        builder.addDateTime(fieldName + "_mintime", AggregatesTableBuilder.instantValueFunction(aggProvider, Aggregate::getMintime, "mintime"));
        builder.addDateTime(fieldName + "_maxtime", AggregatesTableBuilder.instantValueFunction(aggProvider, Aggregate::getMaxtime, "maxtime"));
        builder.addDateTime(fieldName + "_firsttime", AggregatesTableBuilder.instantValueFunction(aggProvider, Aggregate::getFirsttime, "firsttime"));
        builder.addDateTime(fieldName + "_lasttime", AggregatesTableBuilder.instantValueFunction(aggProvider, Aggregate::getLasttime, "lasttime"));
    }

    private static IntFunction<Instant> instantValueFunction(IntFunction<Aggregate> dataProvider, Function<Aggregate, Object> timeExtractor, String fieldName) {
        return i -> {
            Object time;
            Aggregate data = (Aggregate)dataProvider.apply(i);
            if (data != null && (time = timeExtractor.apply(data)) != null) {
                try {
                    return Instant.parse(time.toString());
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e, () -> "Failed to parse " + fieldName + ": " + String.valueOf(time));
                }
            }
            return null;
        };
    }
}

