/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.data;

import com.rapidminer.extension.insightshub.generated.api.assets.model.AspectVariable;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeResourceAllOfAspects;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BeltTableUtils {
    private static final Logger log = Logger.getLogger(BeltTableUtils.class.getName());

    private BeltTableUtils() {
    }

    public static Map<String, AspectVariable.DataTypeEnum> getDataTypeMap(AssetTypeResourceAllOfAspects assetTypeResourceAspect) {
        Map rawAspectTypeMap;
        Map aspectTypeMap;
        Object variablesObj;
        HashMap<String, AspectVariable.DataTypeEnum> dataTypeMap = new HashMap<String, AspectVariable.DataTypeEnum>();
        if (assetTypeResourceAspect == null) {
            return dataTypeMap;
        }
        Object aspectTypeObj = assetTypeResourceAspect.getAspectType();
        if (aspectTypeObj == null) {
            return dataTypeMap;
        }
        if (aspectTypeObj instanceof Map && (variablesObj = (aspectTypeMap = (rawAspectTypeMap = (Map)aspectTypeObj)).get("variables")) instanceof List) {
            List list = (List)variablesObj;
            for (Object variableObj : list) {
                Map map;
                if (!(variableObj instanceof Map)) continue;
                Map variableMap = map = (Map)variableObj;
                String name = (String)variableMap.get("name");
                String dataTypeStr = (String)variableMap.get("dataType");
                if (name == null || dataTypeStr == null) continue;
                try {
                    AspectVariable.DataTypeEnum dataType = AspectVariable.DataTypeEnum.fromValue(dataTypeStr);
                    dataTypeMap.put(name, dataType);
                }
                catch (IllegalArgumentException e) {
                    log.log(Level.WARNING, e, () -> String.format("Unknown data type: %s for variable: %s", dataTypeStr, name));
                }
            }
        }
        return dataTypeMap;
    }

    public static <T> IntToDoubleFunction doubleValueFunction(IntFunction<T> dataProvider, Function<T, Double> valueExtractor) {
        return i -> {
            Object data = dataProvider.apply(i);
            if (data != null) {
                Double value = (Double)valueExtractor.apply(data);
                return value != null ? value : Double.NaN;
            }
            return Double.NaN;
        };
    }

    public static <T> IntToDoubleFunction numberValueFunction(IntFunction<T> dataProvider, Function<T, ? extends Number> valueExtractor) {
        return i -> {
            Object data = dataProvider.apply(i);
            if (data != null) {
                Number value = (Number)valueExtractor.apply(data);
                return value != null ? value.doubleValue() : Double.NaN;
            }
            return Double.NaN;
        };
    }

    public static <T> IntFunction<Instant> instantValueFunction(IntFunction<T> dataProvider, Function<T, OffsetDateTime> timeExtractor) {
        return i -> {
            OffsetDateTime time;
            Object data = dataProvider.apply(i);
            if (data != null && (time = (OffsetDateTime)timeExtractor.apply(data)) != null) {
                return time.toInstant();
            }
            return null;
        };
    }
}

