/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.data;

import com.rapidminer.belt.table.Builders;
import com.rapidminer.belt.table.Table;
import com.rapidminer.belt.table.TableBuilder;
import com.rapidminer.belt.util.Belt;
import com.rapidminer.extension.insightshub.data.BeltTableUtils;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AspectVariable;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeResourceAllOfAspects;
import com.rapidminer.extension.insightshub.generated.api.timeseries.model.TimeSeriesDataItem;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TimeSeriesTableBuilder {
    private static final Logger log = Logger.getLogger(TimeSeriesTableBuilder.class.getName());

    private TimeSeriesTableBuilder() {
    }

    public static Table buildTimeseriesTable(List<TimeSeriesDataItem> timeSeriesData, AssetTypeResourceAllOfAspects assetTypeResourceAspect) {
        if (timeSeriesData == null || timeSeriesData.isEmpty()) {
            return TimeSeriesTableBuilder.createEmptyTable();
        }
        Map<String, AspectVariable.DataTypeEnum> dataTypeMap = BeltTableUtils.getDataTypeMap(assetTypeResourceAspect);
        int rowCount = timeSeriesData.size();
        TimeSeriesDataItem[] dataArray = (TimeSeriesDataItem[])timeSeriesData.toArray(TimeSeriesDataItem[]::new);
        TableBuilder builder = Builders.newTableBuilder((int)rowCount);
        Instant[] times = new Instant[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            TimeSeriesDataItem data = dataArray[i2];
            OffsetDateTime time = data.getTime();
            times[i2] = time != null ? time.toInstant() : null;
        }
        builder.addDateTime("_time", i -> times[i]);
        Map<String, Object> firstItemData = dataArray[0].getAdditionalProperties();
        if (firstItemData != null) {
            for (String columnName : firstItemData.keySet()) {
                AspectVariable.DataTypeEnum dataType = dataTypeMap.get(columnName);
                TimeSeriesTableBuilder.addColumnByType(builder, columnName, dataType, dataArray, rowCount);
            }
        }
        return builder.build(Belt.defaultContext());
    }

    private static Table createEmptyTable() {
        TableBuilder builder = Builders.newTableBuilder((int)0);
        builder.addDateTime("_time", i -> null);
        return builder.build(Belt.defaultContext());
    }

    private static void addColumnByType(TableBuilder builder, String columnName, AspectVariable.DataTypeEnum dataType, TimeSeriesDataItem[] dataArray, int rowCount) {
        if (dataType == null) {
            TimeSeriesTableBuilder.addNominalColumn(builder, columnName, dataArray, rowCount);
            return;
        }
        switch (dataType) {
            case DOUBLE: {
                builder.addReal(columnName, TimeSeriesTableBuilder.getNumericValueFunction(columnName, dataArray, rowCount));
                break;
            }
            case INT: 
            case LONG: {
                builder.addInt53Bit(columnName, TimeSeriesTableBuilder.getNumericValueFunction(columnName, dataArray, rowCount));
                break;
            }
            case BOOLEAN: {
                builder.addNominal(columnName, TimeSeriesTableBuilder.getBooleanValueFunction(columnName, dataArray, rowCount));
                break;
            }
            case TIMESTAMP: {
                builder.addDateTime(columnName, TimeSeriesTableBuilder.preExtractTimestampValues(columnName, dataArray, rowCount));
                break;
            }
            default: {
                TimeSeriesTableBuilder.addNominalColumn(builder, columnName, dataArray, rowCount);
            }
        }
    }

    private static void addNominalColumn(TableBuilder builder, String columnName, TimeSeriesDataItem[] dataArray, int rowCount) {
        String[] values2 = new String[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Object value = dataArray[i2].getAdditionalProperties().get(columnName);
            values2[i2] = value != null ? value.toString() : null;
        }
        builder.addNominal(columnName, i -> values2[i]);
    }

    private static IntToDoubleFunction getNumericValueFunction(String columnName, TimeSeriesDataItem[] dataArray, int rowCount) {
        double[] values2 = new double[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Object value = dataArray[i2].getAdditionalProperties().get(columnName);
            if (value instanceof Number) {
                Number number = (Number)value;
                values2[i2] = number.doubleValue();
                continue;
            }
            if (value != null) {
                try {
                    values2[i2] = Double.parseDouble(value.toString());
                }
                catch (NumberFormatException e) {
                    values2[i2] = Double.NaN;
                }
                continue;
            }
            values2[i2] = Double.NaN;
        }
        return i -> values2[i];
    }

    private static IntFunction<String> getBooleanValueFunction(String columnName, TimeSeriesDataItem[] dataArray, int rowCount) {
        String[] values2 = new String[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Object value = dataArray[i2].getAdditionalProperties().get(columnName);
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                values2[i2] = boolValue.toString();
                continue;
            }
            values2[i2] = value != null ? (Boolean.parseBoolean(value.toString()) ? "true" : "false") : "false";
        }
        return i -> values2[i];
    }

    private static IntFunction<Instant> preExtractTimestampValues(String columnName, TimeSeriesDataItem[] dataArray, int rowCount) {
        Instant[] values2 = new Instant[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            Object value = dataArray[i2].getAdditionalProperties().get(columnName);
            if (value != null) {
                try {
                    values2[i2] = Instant.parse(value.toString());
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e, () -> "Failed to parse timestamp: " + String.valueOf(value));
                    values2[i2] = null;
                }
                continue;
            }
            values2[i2] = null;
        }
        return i -> values2[i];
    }
}

