/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.generated.api.oauth;

import com.google.gson.reflect.TypeToken;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiCallback;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiClient;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiException;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.ApiResponse;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.Configuration;
import com.rapidminer.extension.insightshub.generated.api.oauth.invoker.Pair;
import com.rapidminer.extension.insightshub.generated.api.oauth.model.AccessTokenResponse;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class TokenEndpointApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TokenEndpointApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenEndpointApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call tokenEndpointPostClientCredentialsGrantCall(@Nonnull String grantType, @Nullable String iamAction, @Nullable String subtenant, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }
        if (iamAction != null) {
            localVarFormParams.put("iam-action", iamAction);
        }
        if (subtenant != null) {
            localVarFormParams.put("subtenant", subtenant);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call tokenEndpointPostClientCredentialsGrantValidateBeforeCall(@Nonnull String grantType, @Nullable String iamAction, @Nullable String subtenant, ApiCallback _callback) throws ApiException {
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling tokenEndpointPostClientCredentialsGrant(Async)");
        }
        return this.tokenEndpointPostClientCredentialsGrantCall(grantType, iamAction, subtenant, _callback);
    }

    public AccessTokenResponse tokenEndpointPostClientCredentialsGrant(@Nonnull String grantType, @Nullable String iamAction, @Nullable String subtenant) throws ApiException {
        ApiResponse<AccessTokenResponse> localVarResp = this.tokenEndpointPostClientCredentialsGrantWithHttpInfo(grantType, iamAction, subtenant);
        return localVarResp.getData();
    }

    public ApiResponse<AccessTokenResponse> tokenEndpointPostClientCredentialsGrantWithHttpInfo(@Nonnull String grantType, @Nullable String iamAction, @Nullable String subtenant) throws ApiException {
        Call localVarCall = this.tokenEndpointPostClientCredentialsGrantValidateBeforeCall(grantType, iamAction, subtenant, null);
        Type localVarReturnType = new TypeToken<AccessTokenResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call tokenEndpointPostClientCredentialsGrantAsync(@Nonnull String grantType, @Nullable String iamAction, @Nullable String subtenant, ApiCallback<AccessTokenResponse> _callback) throws ApiException {
        Call localVarCall = this.tokenEndpointPostClientCredentialsGrantValidateBeforeCall(grantType, iamAction, subtenant, _callback);
        Type localVarReturnType = new TypeToken<AccessTokenResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

