/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.generated.api.timeseries.invoker;

import com.rapidminer.extension.insightshub.generated.api.timeseries.invoker.ApiCallback;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final ApiCallback callback;
    private BufferedSource bufferedSource;

    public ProgressResponseBody(ResponseBody responseBody, ApiCallback callback) {
        this.responseBody = responseBody;
        this.callback = callback;
    }

    @Override
    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    @Override
    public long contentLength() {
        return this.responseBody.contentLength();
    }

    @Override
    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer(this.source(this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source2) {
        return new ForwardingSource(source2){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            @Override
            public long read(Buffer sink2, long byteCount) throws IOException {
                long bytesRead = super.read(sink2, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                ProgressResponseBody.this.callback.onDownloadProgress(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength(), bytesRead == -1L);
                return bytesRead;
            }
        };
    }
}

