/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.gui.connection;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.gui.AbstractConnectionGUI;
import com.rapidminer.connection.gui.DefaultConnectionGUI;
import com.rapidminer.connection.gui.model.ConnectionModel;
import com.rapidminer.connection.gui.model.ConnectionParameterGroupModel;
import com.rapidminer.connection.gui.model.ConnectionParameterModel;
import com.rapidminer.repository.RepositoryLocation;
import java.awt.Container;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;

public class InsightsConnectionGUI
extends DefaultConnectionGUI {
    private Set<VisibilityWrapperCreator> visibilityWrapperCreators = new HashSet<VisibilityWrapperCreator>();

    public InsightsConnectionGUI(Window parent, ConnectionInformation connection, RepositoryLocation location, boolean editable) {
        super(parent, connection, location, editable);
    }

    public JComponent getComponentForGroup(ConnectionParameterGroupModel groupModel, ConnectionModel connectionModel) {
        this.addOrSetParameter(groupModel, "tenant");
        this.addOrSetParameter(groupModel, "username");
        this.addOrSetParameter(groupModel, "password");
        JComponent result = super.getComponentForGroup(groupModel, connectionModel);
        for (VisibilityWrapperCreator c : this.visibilityWrapperCreators) {
            c.run();
        }
        return result;
    }

    protected JComponent getParameterLabelComponent(String type, ConnectionParameterModel parameter) {
        return InsightsConnectionGUI.visibilityWrapper((JComponent)super.getParameterLabelComponent(type, parameter), (ConnectionParameterModel)parameter);
    }

    protected JComponent getParameterInputComponent(String type, ConnectionParameterModel parameter) {
        JComponent result = super.getParameterInputComponent(type, parameter);
        this.visibilityWrapperCreators.add(new VisibilityWrapperCreator(result, parameter));
        return result;
    }

    private void addOrSetParameter(ConnectionParameterGroupModel group, String paramName) {
        if (group.getParameter(paramName) == null) {
            boolean isEncrypted = "password".equals(paramName);
            group.addOrSetParameter(paramName, "", isEncrypted, null, true);
        }
    }

    private static class VisibilityWrapperCreator {
        private JComponent component;
        private ConnectionParameterModel parameter;

        VisibilityWrapperCreator(JComponent component, ConnectionParameterModel parameter) {
            this.component = component;
            this.parameter = parameter;
        }

        void run() {
            Container container = this.component.getParent();
            if (container instanceof JComponent) {
                JComponent parent = (JComponent)container;
                AbstractConnectionGUI.visibilityWrapper((JComponent)parent, (ConnectionParameterModel)this.parameter);
            }
        }
    }
}

