/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.ioobject;

import com.rapidminer.extension.insightshub.client.exception.InsightStreamOnlyFileException;
import com.rapidminer.extension.insightshub.util.PathUtils;
import com.rapidminer.operator.nio.file.FileObject;
import java.io.File;
import java.io.InputStream;

public class DataLakeStreamFileObject
extends FileObject {
    private final transient InputStream inputStream;
    private final String fileName;

    public DataLakeStreamFileObject(String filePath, InputStream inputStream2) {
        this.inputStream = inputStream2;
        this.fileName = PathUtils.extractFileName(filePath);
        this.getAnnotations().put("Source", filePath);
        this.getAnnotations().put("Filename", this.fileName);
        this.getAnnotations().put("Comment", "This file represents an Insights Data Lake object");
    }

    public InputStream openStream() {
        return this.inputStream;
    }

    public String getName() {
        return this.fileName;
    }

    public long getLength() {
        return -1L;
    }

    public File getFile() {
        throw new InsightStreamOnlyFileException("This file object can only be streamed.\nThe file is accessed remotely and cannot be provided as a local file.\nSome operators cannot handle streams.\nPlease download the file first before using such operators.\n");
    }

    public String toString() {
        return "Data Lake: " + this.getAnnotations().get((Object)"Source");
    }
}

