/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.operator;

import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.extension.insightshub.client.DataLakeClient;
import com.rapidminer.extension.insightshub.ioobject.DataLakeStreamFileObject;
import com.rapidminer.extension.insightshub.operator.InsightsOperator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.SimpleFileObject;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataLakeReaderOperator
extends InsightsOperator {
    private static final Logger log = Logger.getLogger(DataLakeReaderOperator.class.getName());
    public static final String PARAMETER_PATH = "path";
    public static final String PARAMETER_DOWNLOAD = "download";
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("output");

    public DataLakeReaderOperator(OperatorDescription description) {
        super(description);
        this.initConnectionSelector();
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(ConnectionInformationSelector.createParameterTypes((ConnectionInformationSelector)this.getConnectionSelector()));
        ParameterTypeString pathParam = new ParameterTypeString(PARAMETER_PATH, "Path of the file in the Insights Data Lake", false);
        types.add(pathParam);
        ParameterTypeBoolean downloadParam = new ParameterTypeBoolean(PARAMETER_DOWNLOAD, "Download file to local storage. If false, the file will be streamed directly for better performance and memory usage", false);
        types.add(downloadParam);
        return types;
    }

    @Override
    public void doWork() throws OperatorException {
        super.doWork();
        String path = this.getParameterAsString(PARAMETER_PATH);
        if (path == null || path.trim().isEmpty()) {
            throw new UserError((Operator)this, 100, new Object[]{PARAMETER_PATH});
        }
        boolean download = this.getParameterAsBoolean(PARAMETER_DOWNLOAD);
        try {
            DataLakeClient client = this.createDataLakeRestClient();
            if (download) {
                File downloaded = client.downloadFile(path, null);
                if (downloaded == null || !downloaded.exists()) {
                    throw new UserError((Operator)this, "iot.datalake_download_failed", new Object[]{path});
                }
                SimpleFileObject fileObject = new SimpleFileObject(downloaded);
                fileObject.getAnnotations().put("Insights Hub Data Lake path", path);
                this.outputPort.deliver((IOObject)fileObject);
            } else {
                InputStream stream = client.getFileStream(path, null);
                if (stream == null) {
                    throw new UserError((Operator)this, "iot.datalake_stream_failed", new Object[]{path});
                }
                this.outputPort.deliver((IOObject)new DataLakeStreamFileObject(path, stream));
            }
        }
        catch (UserError ue) {
            throw ue;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> "Failed to read file from Data Lake: " + e.getMessage());
            throw this.mapException(e);
        }
    }
}

