/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.operator;

import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.extension.insightshub.client.DataLakeClient;
import com.rapidminer.extension.insightshub.operator.InsightsOperator;
import com.rapidminer.extension.insightshub.util.PathUtils;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataLakeUploadOperator
extends InsightsOperator {
    private static final Logger log = Logger.getLogger(DataLakeUploadOperator.class.getName());
    public static final String PARAMETER_UPLOAD_PATH = "upload_path";
    private final InputPort fileInputPort;
    private final OutputPort fileOutputPort = (OutputPort)this.getOutputPorts().createPort("file");

    public DataLakeUploadOperator(OperatorDescription description) {
        super(description);
        this.initConnectionSelector();
        this.fileInputPort = (InputPort)this.getInputPorts().createPort("file");
        this.getTransformer().addPassThroughRule(this.fileInputPort, this.fileOutputPort);
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.addAll(ConnectionInformationSelector.createParameterTypes((ConnectionInformationSelector)this.getConnectionSelector()));
        ParameterTypeString uploadPathParam = new ParameterTypeString(PARAMETER_UPLOAD_PATH, "Target path in the Insights Data Lake where the file should be uploaded. If the path ends with '/' or represents a folder (no file extension), the original filename will be appended. Examples: '/data/projectA/subfolder/' or '/data/projectA/subfolder/myfile.csv'", false);
        types.add(uploadPathParam);
        return types;
    }

    @Override
    public void doWork() throws OperatorException {
        super.doWork();
        String uploadPath = this.getParameterAsString(PARAMETER_UPLOAD_PATH);
        FileObject fileObject = (FileObject)this.fileInputPort.getData(FileObject.class);
        if (fileObject == null) {
            throw new UserError((Operator)this, "file.missing");
        }
        try {
            DataLakeClient client = this.createDataLakeRestClient();
            String finalUploadPath = this.determineUploadPath(uploadPath, fileObject.getName());
            try (InputStream fileStream = fileObject.openStream();){
                client.uploadFile(finalUploadPath, fileStream, fileObject.getName(), null);
            }
            log.info(() -> String.format("Successfully uploaded file '%s' to path '%s'", fileObject.getName(), finalUploadPath));
        }
        catch (UserError ue) {
            throw ue;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e, () -> String.format("Failed to upload file to Data Lake: %s", e.getMessage()));
            throw this.mapException(e);
        }
        this.fileOutputPort.deliver((IOObject)fileObject);
    }

    private String determineUploadPath(String uploadPath, String fileName) {
        Object normalizedPath = PathUtils.ensureLeadingSlash(uploadPath);
        if (((String)normalizedPath).endsWith("/") || !((String)normalizedPath).contains(".") && !((String)normalizedPath).substring(((String)normalizedPath).lastIndexOf("/") + 1).contains(".")) {
            normalizedPath = PathUtils.ensureTrailingSlash((String)normalizedPath) + fileName;
        }
        return normalizedPath;
    }
}

