/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationBuilder;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.configuration.ConnectionConfigurationBuilder;
import com.rapidminer.connection.util.ConnectionI18N;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.connection.util.ParameterUtility;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.extension.insightshub.PluginInitInsightsHub;
import com.rapidminer.extension.insightshub.client.AssetClient;
import com.rapidminer.extension.insightshub.client.DataLakeClient;
import com.rapidminer.extension.insightshub.client.TimeSeriesClient;
import com.rapidminer.extension.insightshub.client.exception.InsightsAuthenticationException;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.client.exception.InsightsConflictException;
import com.rapidminer.extension.insightshub.client.exception.InsightsNotFoundException;
import com.rapidminer.extension.insightshub.client.exception.InsightsPreconditionFailedException;
import com.rapidminer.extension.insightshub.client.exception.InsightsRateLimitException;
import com.rapidminer.extension.insightshub.client.exception.InsightsServiceException;
import com.rapidminer.extension.insightshub.client.exception.InsightsValidationException;
import com.rapidminer.extension.insightshub.connection.InsightsCredentials;
import com.rapidminer.extension.insightshub.operator.parameter.ParameterUtils;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;

public class InsightsOperator
extends Operator
implements ConnectionSelectionProvider {
    private static final Logger log = Logger.getLogger(InsightsOperator.class.getName());
    protected ConnectionInformationSelector connectionSelector;

    protected InsightsOperator(OperatorDescription description) {
        super(description);
    }

    public void doWork() throws OperatorException {
        if (this.connectionSelector != null) {
            this.connectionSelector.passDataThrough();
        }
    }

    protected void initConnectionSelector() {
        this.connectionSelector = new ConnectionInformationSelector((Operator)this, "cloud-insights");
        this.connectionSelector.makeDefaultPortTransformation();
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
        this.connectionSelector = selector;
    }

    protected TimeSeriesClient createTimeSeriesClient() throws UserError, InsightsClientException {
        InsightsCredentials credentials = this.getInsightsCredentials();
        return new TimeSeriesClient(credentials);
    }

    public AssetClient createAssetsClient() throws UserError, InsightsClientException {
        InsightsCredentials credentials = this.getInsightsCredentials();
        return new AssetClient(credentials);
    }

    protected DataLakeClient createDataLakeRestClient() throws UserError, InsightsClientException {
        InsightsCredentials credentials = this.getInsightsCredentials();
        return new DataLakeClient(credentials);
    }

    protected ConnectionInformation requireConnection() throws UserError {
        ConnectionInformation ci = null;
        try {
            ci = this.connectionSelector != null ? this.connectionSelector.getConnection() : null;
        }
        catch (UserError e) {
            log.fine(() -> "Failed to get connection from selector: " + e.getMessage());
        }
        if (ci == null) {
            log.fine(() -> "Reading connection from environment variables");
            ci = this.createConnectionFromEnvironment();
        }
        if (ci == null) {
            throw new UserError((Operator)this, "connection.missing");
        }
        return ci;
    }

    private ConnectionInformation createConnectionFromEnvironment() throws UserError {
        String tenant = System.getenv("RAPIDMINER_INSIGHTS_TENANT");
        String username = System.getenv("RAPIDMINER_INSIGHTS_USERNAME");
        String password = System.getenv("RAPIDMINER_INSIGHTS_PASSWORD");
        log.fine(() -> "RAPIDMINER_INSIGHTS_TENANT: " + tenant);
        log.fine(() -> "RAPIDMINER_INSIGHTS_USERNAME: " + username);
        log.fine(() -> "RAPIDMINER_INSIGHTS_PASSWORD: " + (password != null ? "<present>" : "<not present>"));
        ConnectionConfigurationBuilder configBuilder = new ConnectionConfigurationBuilder("Cloud Default", "cloud-insights");
        configBuilder.withKeys("basic", Arrays.asList((ConfigurationParameter)ParameterUtility.getCPBuilder((String)"tenant", (boolean)false).withValue(tenant).build(), (ConfigurationParameter)ParameterUtility.getCPBuilder((String)"username", (boolean)false).withValue(username).build(), (ConfigurationParameter)ParameterUtility.getCPBuilder((String)"password", (boolean)true).withValue(password).build()));
        ConnectionInformationBuilder infoBuilder = new ConnectionInformationBuilder(configBuilder.build());
        return infoBuilder.build();
    }

    private InsightsCredentials getInsightsCredentials() throws UserError {
        ConnectionInformation connection = this.requireConnection();
        Map injectedValues = ValueProviderHandlerRegistry.getInstance().injectValues(connection, (Operator)this, false);
        String tenant = this.getConnectionParameter(injectedValues, "basic", "tenant");
        String username = this.getConnectionParameter(injectedValues, "basic", "username");
        String password = this.getConnectionParameter(injectedValues, "basic", "password");
        return new InsightsCredentials(tenant, username, password);
    }

    private String getConnectionParameter(Map<String, String> injectedValues, String group, String param) throws UserError {
        String key = group + "." + param;
        String value = injectedValues.get(key);
        if (value == null || value.trim().isEmpty()) {
            String displayName = ConnectionI18N.getParameterName((String)"cloud-insights", (String)group, (String)param);
            throw new UserError(null, "connection.parameter_missing", new Object[]{displayName});
        }
        return value;
    }

    protected String getIsoDateTimeParameter(String parameterName) throws UserError {
        if (!this.isParameterSet(parameterName)) {
            return null;
        }
        String input = this.getParameterAsString(parameterName);
        if (input == null || input.isBlank()) {
            return null;
        }
        try {
            ZonedDateTime zdt = ParameterUtils.DATETIME_FORMATTER.parse((CharSequence)input, temporal -> LocalDateTime.from(temporal).atZone(ZoneOffset.UTC));
            return ParameterUtils.toIsoString(zdt);
        }
        catch (DateTimeParseException e) {
            throw new UserError((Operator)this, "insights.invalid_date_parameter", new Object[]{input});
        }
    }

    protected ZonedDateTime getZonedDateTimeParameter(String parameterName) throws UserError {
        if (!this.isParameterSet(parameterName)) {
            return null;
        }
        String input = this.getParameterAsString(parameterName);
        if (input == null || input.isBlank()) {
            return null;
        }
        try {
            return ParameterUtils.DATETIME_FORMATTER.parse((CharSequence)input, temporal -> LocalDateTime.from(temporal).atZone(ZoneOffset.UTC));
        }
        catch (DateTimeParseException e) {
            throw new UserError((Operator)this, "insights.invalid_date_parameter", new Object[]{input});
        }
    }

    protected OffsetDateTime getOffsetDateTimeParameter(String parameterName) throws UserError {
        ZonedDateTime zdt = this.getZonedDateTimeParameter(parameterName);
        return zdt != null ? zdt.toOffsetDateTime() : null;
    }

    protected OperatorException mapException(InsightsClientException e) throws OperatorException {
        String message = e.getMessage();
        if (e instanceof InsightsAuthenticationException) {
            throw new UserError((Operator)this, (Throwable)e, "insights.authentication_failed", new Object[]{message});
        }
        if (e instanceof InsightsNotFoundException) {
            throw new UserError((Operator)this, (Throwable)e, "insights.not_found", new Object[]{message});
        }
        if (e instanceof InsightsValidationException) {
            throw new UserError((Operator)this, (Throwable)e, "insights.validation_error", new Object[]{message});
        }
        if (e instanceof InsightsConflictException) {
            throw new UserError((Operator)this, (Throwable)e, "insights.conflict", new Object[]{message});
        }
        if (e instanceof InsightsPreconditionFailedException) {
            throw new UserError((Operator)this, (Throwable)e, "insights.precondition_failed", new Object[]{message});
        }
        if (e instanceof InsightsRateLimitException) {
            throw new OperatorException("process.insights.rate_limit_exceeded: " + message, (Throwable)e);
        }
        if (e instanceof InsightsServiceException) {
            throw new OperatorException("process.insights.service_error: " + message, (Throwable)e);
        }
        throw new OperatorException("process.insights.unexpected_error: " + message, (Throwable)e);
    }

    protected OperatorException mapException(Exception e) throws OperatorException {
        if (e instanceof InsightsClientException) {
            InsightsClientException clientEx = (InsightsClientException)e;
            return this.mapException(clientEx);
        }
        throw new OperatorException("process.insights.unexpected_error: " + e.getMessage(), (Throwable)e);
    }

    static {
        PluginInitInsightsHub.verifyInstallation();
    }
}

