/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.operator;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.table.Table;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.extension.insightshub.client.AssetClient;
import com.rapidminer.extension.insightshub.client.TimeSeriesClient;
import com.rapidminer.extension.insightshub.client.exception.InsightsClientException;
import com.rapidminer.extension.insightshub.client.exception.InsightsNotFoundException;
import com.rapidminer.extension.insightshub.client.model.AggregatesV4Response;
import com.rapidminer.extension.insightshub.data.AggregatesTableBuilder;
import com.rapidminer.extension.insightshub.data.TimeSeriesTableBuilder;
import com.rapidminer.extension.insightshub.generated.api.assets.model.AssetTypeResourceAllOfAspects;
import com.rapidminer.extension.insightshub.generated.api.timeseries.model.TimeSeriesDataItem;
import com.rapidminer.extension.insightshub.operator.InsightsOperator;
import com.rapidminer.extension.insightshub.operator.parameter.EnumParameter;
import com.rapidminer.extension.insightshub.operator.parameter.ParameterUtils;
import com.rapidminer.extension.insightshub.operator.parameter.SortOrder;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDateTimeString;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeLong;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimeSeriesReaderOperator
extends InsightsOperator {
    private static final Logger log = Logger.getLogger(TimeSeriesReaderOperator.class.getName());
    private static final String PARAMETER_ASSET = "asset";
    private static final String PARAMETER_ASPECT = "aspect";
    private static final String PARAMETER_LIMIT = "limit";
    private static final String PARAMETER_VARIABLES = "variables";
    private static final String PARAMETER_SORT = "sort";
    private static final String PARAMETER_BULK_READ = "bulk_read";
    private static final String PARAMETER_LATEST_VALUE = "latest_value";
    private static final String PARAMETER_FROM = "from";
    private static final String PARAMETER_TO = "to";
    private static final String PARAMETER_INTERVAL_UNIT = "interval_unit";
    private static final String PARAMETER_INTERVAL_VALUE = "interval_value";
    private static final String PARAMETER_AGGREGATE = "aggregate";
    private static final ChronoUnit[] TIME_UNITS = new ChronoUnit[]{ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.DAYS};
    private static final String[] TIME_UNIT_VALUES = (String[])Arrays.stream(TIME_UNITS).map(Enum::name).toArray(String[]::new);
    private static final String[] SORT_VALUES = EnumParameter.getValues(SortOrder.class);
    private static final int DEFAULT_SORT_VALUE_INDEX = Arrays.binarySearch(SORT_VALUES, SortOrder.ASC.name());
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("output");
    private static final Map<ChronoUnit, String> CHRONO_UNIT_TO_STRING = Map.of(ChronoUnit.SECONDS, "second", ChronoUnit.MINUTES, "minute", ChronoUnit.HOURS, "hour", ChronoUnit.DAYS, "day");

    public TimeSeriesReaderOperator(OperatorDescription description) {
        super(description);
        this.initConnectionSelector();
    }

    public List<ParameterType> getParameterTypes() {
        ParameterTypeString assetParam = new ParameterTypeString(PARAMETER_ASSET, "Asset name or ID containing the time series data", false);
        ParameterTypeString aspectParam = new ParameterTypeString(PARAMETER_ASPECT, "Aspect name (property set) defining the data structure", false);
        ParameterTypeString variablesParam = new ParameterTypeString(PARAMETER_VARIABLES, "Comma-separated list of variables to be returned", true, false);
        ParameterTypeBoolean bulkReadParam = new ParameterTypeBoolean(PARAMETER_BULK_READ, "Use bulk read API for improved performance with large datasets (requires from and to dates)", false);
        ParameterTypeBoolean latestValueParam = new ParameterTypeBoolean(PARAMETER_LATEST_VALUE, "Return the latest value only", false);
        BooleanParameterCondition latestValueCondition = new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LATEST_VALUE, false, false);
        ParameterTypeBoolean aggregateParam = new ParameterTypeBoolean(PARAMETER_AGGREGATE, "Enable aggregation of time series data", false);
        ParameterTypeInt intervalValueParam = new ParameterTypeInt(PARAMETER_INTERVAL_VALUE, "Time length for 'last period' mode", 1, Integer.MAX_VALUE, 1, false);
        ParameterTypeCategory intervalUnitParam = new ParameterTypeCategory(PARAMETER_INTERVAL_UNIT, "Time unit for 'last period' mode", TIME_UNIT_VALUES, 2, false);
        BooleanParameterCondition aggregateTrueCondition = new BooleanParameterCondition((ParameterHandler)this, PARAMETER_AGGREGATE, false, true);
        ParameterTypeDateTimeString fromParam = new ParameterTypeDateTimeString(PARAMETER_FROM, "Beginning of the time range to be retrieved (inclusive)", true, false, ParameterUtils.DATETIME_FORMATTER);
        ParameterTypeDateTimeString toParam = new ParameterTypeDateTimeString(PARAMETER_TO, "End of the time range to be retrieved (inclusive)", true, false, ParameterUtils.DATETIME_FORMATTER);
        ParameterTypeCategory sortParam = new ParameterTypeCategory(PARAMETER_SORT, "Sorting order of returned data", SORT_VALUES, DEFAULT_SORT_VALUE_INDEX, true);
        ParameterTypeLong limitParam = new ParameterTypeLong(PARAMETER_LIMIT, "Maximum number of time series data items to be retrieved", 0L, Long.MAX_VALUE, true);
        List.of(intervalValueParam, intervalUnitParam, fromParam, toParam, aggregateParam, bulkReadParam, sortParam, limitParam).forEach(arg_0 -> TimeSeriesReaderOperator.lambda$getParameterTypes$1((ParameterCondition)latestValueCondition, arg_0));
        List.of(intervalValueParam, intervalUnitParam).forEach(arg_0 -> TimeSeriesReaderOperator.lambda$getParameterTypes$2((ParameterCondition)aggregateTrueCondition, arg_0));
        List types = super.getParameterTypes();
        types.addAll(ConnectionInformationSelector.createParameterTypes((ConnectionInformationSelector)this.getConnectionSelector()));
        types.addAll(List.of(assetParam, aspectParam, variablesParam, latestValueParam, bulkReadParam, aggregateParam, fromParam, toParam, intervalValueParam, intervalUnitParam, sortParam, limitParam));
        return types;
    }

    @Override
    public void doWork() throws OperatorException {
        log.info(() -> "Starting data retrieval");
        try {
            TimeSeriesClient timeSeriesClient = this.createTimeSeriesClient();
            AssetClient assetsClient = this.createAssetsClient();
            String assetId = this.resolveAssetId(assetsClient, this.getParameterAsString(PARAMETER_ASSET));
            String aspectName = this.resolveAspectName(assetsClient, assetId, this.getParameterAsString(PARAMETER_ASPECT));
            String fromIso = null;
            String toIso = null;
            Integer limit = null;
            String variables = null;
            String sort = null;
            boolean isLatestValue = this.getParameterAsBoolean(PARAMETER_LATEST_VALUE);
            if (!this.getParameterAsBoolean(PARAMETER_LATEST_VALUE)) {
                fromIso = this.getIsoDateTimeParameter(PARAMETER_FROM);
                toIso = this.getIsoDateTimeParameter(PARAMETER_TO);
                if (this.isParameterSet(PARAMETER_LIMIT)) {
                    limit = this.getParameterAsInt(PARAMETER_LIMIT);
                }
                if (this.isParameterSet(PARAMETER_VARIABLES)) {
                    variables = this.getParameterAsString(PARAMETER_VARIABLES);
                }
                sort = this.getParameterAsString(PARAMETER_SORT);
            }
            AssetTypeResourceAllOfAspects assetTypeResourceAspect = assetsClient.getAssetTypeResourceAspect(assetId, aspectName);
            if (this.getParameterAsBoolean(PARAMETER_AGGREGATE)) {
                String intervalUnit = null;
                int intervalValue = this.getParameterAsInt(PARAMETER_INTERVAL_VALUE);
                String unitStr = this.getParameterAsString(PARAMETER_INTERVAL_UNIT);
                if (unitStr != null) {
                    ChronoUnit unit = ChronoUnit.valueOf(unitStr);
                    intervalUnit = CHRONO_UNIT_TO_STRING.get(unit);
                }
                AggregatesV4Response aggregates = timeSeriesClient.retrieveAggregatesV4(assetId, aspectName, fromIso, toIso, intervalValue, intervalUnit, variables, limit);
                Table table = AggregatesTableBuilder.buildAggregatesV4Table(aggregates, assetTypeResourceAspect);
                this.outputPort.deliver((IOObject)new IOTable(table));
            } else {
                boolean useBulkRead = this.getParameterAsBoolean(PARAMETER_BULK_READ);
                List<TimeSeriesDataItem> data = useBulkRead ? timeSeriesClient.retrieveBulkTimeSeriesData(assetId, aspectName, fromIso, toIso, limit, variables) : timeSeriesClient.retrieveTimeSeriesData(assetId, aspectName, fromIso, toIso, limit, variables, sort, isLatestValue);
                Table table = TimeSeriesTableBuilder.buildTimeseriesTable(data, assetTypeResourceAspect);
                this.outputPort.deliver((IOObject)new IOTable(table));
            }
            log.info(() -> "Successfully retrieved data");
        }
        catch (InsightsClientException e) {
            log.log(Level.SEVERE, e, () -> "Insights client error: " + e.getMessage());
            throw this.mapException(e);
        }
        catch (OperatorException e) {
            throw e;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t, () -> "Unexpected error: " + t.getMessage());
            throw new OperatorException("process.insights.unexpected_error: " + t.getMessage(), t);
        }
    }

    private String resolveAssetId(AssetClient assetsClient, String assetInput) throws OperatorException {
        if (AssetClient.isInsightsId(assetInput)) {
            return assetInput;
        }
        try {
            String assetId = assetsClient.getAssetId(assetInput);
            if (assetId == null) {
                throw new UserError((Operator)this, "insights.not_found", new Object[]{"Asset with name '" + assetInput + "' not found."});
            }
            return assetId;
        }
        catch (InsightsNotFoundException e) {
            throw new UserError((Operator)this, (Throwable)e, "insights.not_found", new Object[]{"Asset with name '" + assetInput + "' not found."});
        }
        catch (InsightsClientException e) {
            throw this.mapException(e);
        }
    }

    private String resolveAspectName(AssetClient assetsClient, String assetId, String aspectInput) throws OperatorException {
        if (!AssetClient.isInsightsId(aspectInput)) {
            return aspectInput;
        }
        try {
            String aspectName = assetsClient.getAspectName(assetId, aspectInput);
            if (aspectName == null) {
                throw new UserError((Operator)this, "insights.not_found", new Object[]{"Aspect with ID '" + aspectInput + "' in Asset '" + assetId + "'."});
            }
            return aspectName;
        }
        catch (InsightsNotFoundException e) {
            throw new UserError((Operator)this, (Throwable)e, "insights.not_found", new Object[]{"Asset with ID '" + assetId + "'", e.getMessage()});
        }
        catch (InsightsClientException e) {
            throw this.mapException(e);
        }
    }

    private static /* synthetic */ void lambda$getParameterTypes$2(ParameterCondition aggregateTrueCondition, ParameterType param) {
        param.registerDependencyCondition(aggregateTrueCondition);
    }

    private static /* synthetic */ void lambda$getParameterTypes$1(ParameterCondition latestValueCondition, ParameterType param) {
        param.registerDependencyCondition(latestValueCondition);
    }
}

