/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.operator.parameter;

import java.util.Arrays;
import java.util.Locale;

public interface EnumParameter<T extends Enum<T>> {
    public static <T extends Enum<T>> String[] getValues(Class<T> enumClass) {
        return (String[])Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).toArray(String[]::new);
    }

    public static <T extends Enum<T>> T fromString(Class<T> enumClass, String value) {
        if (value == null) {
            throw new IllegalArgumentException(enumClass.getSimpleName() + " value cannot be null");
        }
        String upperValue = value.toUpperCase(Locale.ROOT).trim();
        try {
            return Enum.valueOf(enumClass, upperValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid " + enumClass.getSimpleName() + ": '" + value + "'. Valid values are: " + Arrays.toString(enumClass.getEnumConstants()));
        }
    }
}

