/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.operator.parameter;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public final class ParameterUtils {
    public static final String DATETIME_FORMATTER_PATTERN = "yyyy-MM-dd HH:mm:ss[.SSS]";
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS]");
    private static final DateTimeFormatter ISO_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static String toIsoString(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.withZoneSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS).format(ISO_WITH_MILLIS);
    }

    public static OffsetDateTime toOffsetDateTime(String isoString) {
        if (isoString == null || isoString.isBlank()) {
            return null;
        }
        return OffsetDateTime.parse(isoString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    private ParameterUtils() {
        throw new AssertionError((Object)"Initialization of static utility class.");
    }
}

