/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.text.MessageFormat;
import java.util.Locale;

public final class InsightsTools {
    public static final String DEFAULT_HOST_ENVIRONMENT = "eu1";
    public static final String DEFAULT_HOST_BASEDOMAIN = "mindsphere.io";
    public static final String GATEWAY_URL_FORMAT = "https://gateway.{0}.{1}";
    public static final String TECHNICALTOKEN_URL_FORMAT = "https://tenant.piam.{0}.{1}/oauth/token";

    private InsightsTools() {
    }

    public static String getGatewayUrl() {
        return MessageFormat.format(GATEWAY_URL_FORMAT, DEFAULT_HOST_ENVIRONMENT, DEFAULT_HOST_BASEDOMAIN);
    }

    public static String buildAssetTypeId(String assetTypeName, String tenant) {
        if (assetTypeName == null || assetTypeName.isEmpty()) {
            return assetTypeName;
        }
        if (assetTypeName.contains(".") && !assetTypeName.startsWith(".")) {
            return assetTypeName;
        }
        if (tenant != null && !tenant.isEmpty()) {
            return tenant + "." + assetTypeName;
        }
        return assetTypeName;
    }

    public static String extractTenantFromJWT(String accessToken) {
        if (accessToken == null || accessToken.trim().isEmpty()) {
            throw new IllegalArgumentException("Access token cannot be null or empty");
        }
        String token = accessToken.trim();
        if (token.toLowerCase(Locale.ROOT).startsWith("bearer ")) {
            token = token.substring(7).trim();
        }
        try {
            DecodedJWT jwt = JWT.decode(token);
            String tenant = jwt.getClaim("ten").asString();
            if (tenant == null || tenant.isEmpty()) {
                throw new IllegalStateException("JWT token does not contain a valid 'ten' claim");
            }
            return tenant;
        }
        catch (JWTDecodeException e) {
            throw new IllegalStateException("Failed to decode JWT token: " + e.getMessage(), e);
        }
    }
}

