/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.insightshub.util;

public final class PathUtils {
    private PathUtils() {
    }

    public static String extractFileName(String path) {
        if (path == null || path.isEmpty()) {
            return "unknown";
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash < path.length() - 1) {
            return path.substring(lastSlash + 1);
        }
        return lastSlash >= 0 ? "" : path;
    }

    public static String ensureLeadingSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public static String ensureTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.endsWith("/") ? path : path + "/";
    }

    public static String removeLeadingSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static String removeTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
    }

    public static String trimSlashes(String path) {
        if (path == null) {
            return "";
        }
        return path.replaceAll("^/+|/+$", "");
    }

    public static String extractLastPathSegment(String path) {
        if (path == null || path.trim().isEmpty()) {
            return "";
        }
        String cleaned = path.replaceAll("/+$", "").trim();
        if (cleaned.isEmpty()) {
            return "";
        }
        int lastSlash = cleaned.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash < cleaned.length() - 1) {
            return cleaned.substring(lastSlash + 1);
        }
        return cleaned;
    }
}

