/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.connection;

import com.rapidminer.connection.ConnectionHandler;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationBuilder;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.configuration.ConnectionConfiguration;
import com.rapidminer.connection.configuration.ConnectionConfigurationBuilder;
import com.rapidminer.connection.util.ParameterUtility;
import com.rapidminer.connection.util.TestExecutionContext;
import com.rapidminer.connection.util.TestResult;
import com.rapidminer.connection.util.ValidationResult;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.operator.Operator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.json.JSONObject;

public enum NavopsConnHandler implements ConnectionHandler
{
    INSTANCE;

    public static final String NAVOPS_TYPE_ID = "navops-conn";
    public static final String NAVOPS_FULL_TYPE = "navops_conn:navops-conn";
    public static final String GROUP_BASIC = "basic";
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_API_KEY = "apikey";
    public static final String PARAMETER_ALLOW_UNSECURED = "allow_unsecured";

    public ConnectionInformation createNewConnectionInformation(String name) {
        ConnectionConfigurationBuilder configBuilder = new ConnectionConfigurationBuilder(name, NAVOPS_FULL_TYPE);
        ArrayList<ConfigurationParameter> parameters = new ArrayList<ConfigurationParameter>();
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_URL).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_API_KEY, (boolean)true).build());
        configBuilder.withKeys(GROUP_BASIC, parameters);
        return new ConnectionInformationBuilder(configBuilder.build()).build();
    }

    public String getType() {
        return NAVOPS_FULL_TYPE;
    }

    public ValidationResult validate(ConnectionInformation connection) {
        if (connection == null) {
            return ValidationResult.nullable();
        }
        ConnectionConfiguration configuration = connection.getConfiguration();
        if (configuration == null) {
            return ValidationResult.nullable();
        }
        LinkedHashMap errors = new LinkedHashMap();
        BiConsumer<String, String> errorCollector = errors::put;
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_URL, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_API_KEY, (ConnectionConfiguration)configuration, errorCollector);
        return errors.isEmpty() ? ValidationResult.success((String)"validation.success") : ValidationResult.failure((String)"validation.failed", errors, (Object[])new Object[0]);
    }

    public TestResult test(TestExecutionContext<ConnectionInformation> testContext) {
        try {
            ConnectionInformation connectionInfo = (ConnectionInformation)testContext.getSubject();
            String token = NavopsConnHandler.getToken(connectionInfo, null);
            if (token != null && !token.isEmpty()) {
                return TestResult.success((String)"Connection test successful.");
            }
            return TestResult.failure((String)"Connection failed.", (Object[])new Object[]{"Empty token received."});
        }
        catch (RuntimeException e) {
            return TestResult.failure((String)e.getMessage(), (Object[])new Object[]{"Connection failed."});
        }
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public static Map<String, String> getConfiguration(ConnectionInformation connection, Operator operator) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        Map connectionValues = ValueProviderHandlerRegistry.getInstance().injectValues(connection, operator, false);
        String url = (String)connectionValues.get("basic.url");
        String apiKey = (String)connectionValues.get("basic.apikey");
        if (url == null || apiKey == null) {
            throw new IllegalArgumentException("Configuration parameters (URL or API Key) are missing.");
        }
        values.put(PARAMETER_URL, url);
        values.put(PARAMETER_API_KEY, apiKey);
        return values;
    }

    public static String getToken(ConnectionInformation connectionInfo, Operator operator) {
        System.out.println("DEBUG: getToken() called");
        Map<String, String> config = NavopsConnHandler.getConfiguration(connectionInfo, operator);
        try {
            String endpointUrl = config.get(PARAMETER_URL) + "/api/v1/token";
            String apiKey = config.get(PARAMETER_API_KEY);
            if (config.get(PARAMETER_URL) == null || config.get(PARAMETER_API_KEY) == null) {
                throw new RuntimeException("Configuration is missing. Ensure URL and API Key are set in RM Studio.");
            }
            URL endpoint = new URL(endpointUrl);
            HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("X-Api-Key", apiKey);
            connection.setDoOutput(true);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                JSONObject jsonResponse = new JSONObject(response.toString());
                return jsonResponse.getString("object");
            }
            if (responseCode == 401) {
                throw new RuntimeException("Invalid API key provided. Please verify your API key.");
            }
            if (responseCode == 404) {
                throw new RuntimeException("API endpoint not found. Please verify the URL.");
            }
            throw new RuntimeException("Failed to fetch token. HTTP response code: " + responseCode);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Unable to resolve host. Please verify that the URL is correct.", e);
        }
        catch (ConnectException e) {
            throw new RuntimeException("Connection was refused. Please check the URL and your network connectivity.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while fetching token: " + e.getMessage(), e);
        }
    }
}

