/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.connection;

import com.rapidminer.connection.ConnectionHandler;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.ConnectionInformationBuilder;
import com.rapidminer.connection.configuration.ConfigurationParameter;
import com.rapidminer.connection.configuration.ConnectionConfiguration;
import com.rapidminer.connection.configuration.ConnectionConfigurationBuilder;
import com.rapidminer.connection.util.ParameterUtility;
import com.rapidminer.connection.util.TestExecutionContext;
import com.rapidminer.connection.util.TestResult;
import com.rapidminer.connection.util.ValidationResult;
import com.rapidminer.connection.valueprovider.handler.ValueProviderHandlerRegistry;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.json.JSONObject;

public enum PBSGraphQLConnHandler implements ConnectionHandler
{
    INSTANCE;

    public static final String PBS_TYPE_ID = "pbs-graphql-conn";
    public static final String PBS_FULL_TYPE = "navops_conn:pbs-graphql-conn";
    public static final String GROUP_BASIC = "basic";
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_API_KEY = "apikey";

    public ConnectionInformation createNewConnectionInformation(String name) {
        ConnectionConfigurationBuilder configBuilder = new ConnectionConfigurationBuilder(name, PBS_FULL_TYPE);
        ArrayList<ConfigurationParameter> parameters = new ArrayList<ConfigurationParameter>();
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_URL).build());
        parameters.add((ConfigurationParameter)ParameterUtility.getCPBuilder((String)PARAMETER_API_KEY, (boolean)true).build());
        configBuilder.withKeys(GROUP_BASIC, parameters);
        return new ConnectionInformationBuilder(configBuilder.build()).build();
    }

    public String getType() {
        return PBS_FULL_TYPE;
    }

    public ValidationResult validate(ConnectionInformation connection) {
        if (connection == null) {
            return ValidationResult.nullable();
        }
        ConnectionConfiguration configuration = connection.getConfiguration();
        if (configuration == null) {
            return ValidationResult.nullable();
        }
        LinkedHashMap errors = new LinkedHashMap();
        BiConsumer<String, String> errorCollector = errors::put;
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_URL, (ConnectionConfiguration)configuration, errorCollector);
        ParameterUtility.validateParameterValue((String)GROUP_BASIC, (String)PARAMETER_API_KEY, (ConnectionConfiguration)configuration, errorCollector);
        return errors.isEmpty() ? ValidationResult.success((String)"validation.success") : ValidationResult.failure((String)"validation.failed", errors, (Object[])new Object[0]);
    }

    public TestResult test(TestExecutionContext<ConnectionInformation> testContext) {
        try {
            ConnectionInformation connectionInfo = (ConnectionInformation)testContext.getSubject();
            this.test_connection(connectionInfo, null);
            return TestResult.success((String)"Connection test successful.");
        }
        catch (OperatorException e) {
            return TestResult.failure((String)("Connection test failed: " + e.getMessage()), (Object[])new Object[0]);
        }
        catch (RuntimeException e) {
            return TestResult.failure((String)e.getMessage(), (Object[])new Object[]{"Connection failed."});
        }
    }

    public void initialize() {
    }

    public boolean isInitialized() {
        return true;
    }

    public static Map<String, String> getConfiguration(ConnectionInformation connection, Operator operator) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection must not be null.");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        Map connectionValues = ValueProviderHandlerRegistry.getInstance().injectValues(connection, operator, false);
        String url = (String)connectionValues.get("basic.url");
        String apiKey = (String)connectionValues.get("basic.apikey");
        if (url == null || apiKey == null) {
            throw new IllegalArgumentException("Configuration parameters (URL or API Key) are missing.");
        }
        values.put(PARAMETER_URL, url);
        values.put(PARAMETER_API_KEY, apiKey);
        return values;
    }

    private void test_connection(ConnectionInformation connectionInfo, Operator operator) throws OperatorException {
        Map<String, String> config = PBSGraphQLConnHandler.getConfiguration(connectionInfo, operator);
        String endpointUrl = config.get(PARAMETER_URL);
        String apiKey = config.get(PARAMETER_API_KEY);
        if (config.get(PARAMETER_URL) == null || config.get(PARAMETER_API_KEY) == null) {
            throw new RuntimeException("Configuration is missing. Ensure URL and API Key are set in RM Studio.");
        }
        String graphql_query = "query jobInfo{\n  jobs {\n    edges {\n      node {\n        jobId\n        name\n      }\n    }\n  }\n}";
        try {
            JSONObject payload = new JSONObject();
            payload.put("query", (Object)graphql_query);
            HttpURLConnection con = (HttpURLConnection)new URL(endpointUrl).openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Authorization", "Bearer " + apiKey);
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            int responseCode = con.getResponseCode();
            if (responseCode == 202 || responseCode == 200) {
                return;
            }
            if (responseCode == 401) {
                throw new RuntimeException("Invalid API key provided. Please verify your API key.");
            }
            if (responseCode == 404) {
                throw new RuntimeException("API endpoint not found. Please verify the URL.");
            }
        }
        catch (Exception e) {
            throw new OperatorException("Connection test failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

