/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONObject;

public class GetActionStatusOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");
    private final InputPort inputPort = (InputPort)this.getInputPorts().createPort("action ids");
    public static final String PARAM_POLL_INTERVAL = "poll_interval_seconds";

    public GetActionStatusOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
        this.connectionSelector.makeDefaultPortTransformation();
        this.inputPort.addPrecondition((Precondition)new ExampleSetPrecondition(this.inputPort));
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing. Please verify your Navops connection credentials.");
        }
        ExampleSet inputSet = (ExampleSet)this.inputPort.getData(ExampleSet.class);
        Attribute actionIdAttr = inputSet.getAttributes().get("action_id");
        if (actionIdAttr == null) {
            throw new OperatorException("Input ExampleSet must contain a column named 'action_id'.");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(AttributeFactory.createAttribute((String)"action_id", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"status", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"error", (int)5));
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        String navopUrl = configuration.get("url");
        boolean loopUntilCompleted = this.getParameterAsBoolean("loop_until_completed");
        int pollInterval = this.getParameterAsInt(PARAM_POLL_INTERVAL);
        int timeoutSec = this.getParameterAsInt("timeout_seconds");
        for (Example example : inputSet) {
            String actionId = example.getValueAsString(actionIdAttr);
            if (actionId == null || actionId.trim().isEmpty()) {
                LogService.getRoot().log(Level.WARNING, "Skipping empty action_id row.");
                continue;
            }
            String url = navopUrl + "/api/v1/node-request/actions/" + actionId;
            boolean completed = false;
            String status = "";
            String error = "";
            long startTime = System.currentTimeMillis();
            do {
                try {
                    String line;
                    URL obj = new URL(url);
                    HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                    con.setRequestMethod("GET");
                    con.setRequestProperty("Authorization", "Bearer " + token);
                    con.setRequestProperty("Accept", "application/json");
                    int responseCode = con.getResponseCode();
                    if (responseCode != 200) {
                        throw new OperatorException("HTTP " + responseCode + " returned by Navops for URL: " + url);
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    JSONObject jsonResponse = new JSONObject(response.toString());
                    status = jsonResponse.optString("status", "");
                    error = jsonResponse.optString("error", "");
                    LogService.getRoot().log(Level.INFO, "Action_id=" + actionId + " status=" + status);
                    if ("completed".equalsIgnoreCase(status) || "failed".equalsIgnoreCase(status) || "error".equalsIgnoreCase(status)) {
                        completed = true;
                        continue;
                    }
                    long elapsedSec = (System.currentTimeMillis() - startTime) / 1000L;
                    if (elapsedSec >= (long)timeoutSec) {
                        LogService.getRoot().log(Level.WARNING, "Timeout reached for action_id=" + actionId);
                        status = "TIMEOUT";
                        completed = true;
                        continue;
                    }
                    if (loopUntilCompleted) {
                        Thread.sleep((long)pollInterval * 1000L);
                        continue;
                    }
                    completed = true;
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "Failed to get action status for " + actionId + ": " + e.getMessage());
                    status = "ERROR";
                    error = e.getMessage();
                    completed = true;
                }
            } while (!completed);
            this.addRow(table, attributes, actionId, status, error);
            LogService.getRoot().log(Level.INFO, "Added row: action_id=" + actionId + " status=" + status + " error=" + error);
        }
        ExampleSet output = table.createExampleSet();
        this.connectionSelector.passDataThrough();
        this.outputPort.deliver((IOObject)output);
    }

    private void addRow(MemoryExampleTable table, List<Attribute> attributes, String actionId, String status, String error) {
        double[] values = new double[attributes.size()];
        values[0] = attributes.get(0).getMapping().mapString(actionId);
        values[1] = attributes.get(1).getMapping().mapString(status);
        values[2] = attributes.get(2).getMapping().mapString(error);
        table.addDataRow((DataRow)new DoubleArrayDataRow(values));
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean loopParam = new ParameterTypeBoolean("loop_until_completed", "Whether to keep polling until the action is completed/failed (checked = yes).", true);
        types.add(loopParam);
        ParameterTypeInt timeoutParam = new ParameterTypeInt("timeout_seconds", "Timeout (in sec) to stop looping if no terminal status is reached.", 1, Integer.MAX_VALUE, 90);
        timeoutParam.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "loop_until_completed", true, true));
        types.add(timeoutParam);
        ParameterTypeInt pollParam = new ParameterTypeInt(PARAM_POLL_INTERVAL, "Polling interval in seconds to retry until the action is completed or failed", 1, Integer.MAX_VALUE, 5);
        pollParam.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, "loop_until_completed", true, true));
        types.add(pollParam);
        return types;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

