/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetInstanceTypesOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");
    public static final String PARAMETER_NODE_CLASS_UI = "node class uid";

    public GetInstanceTypesOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
        this.connectionSelector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing. Please verify your Navops connection credentials.");
        }
        String navopUrl = configuration.get("url");
        String nodeClassUid = this.getParameterAsString(PARAMETER_NODE_CLASS_UI);
        if (nodeClassUid == null || nodeClassUid.trim().isEmpty()) {
            throw new OperatorException("Missing node class UID. Please provide a valid UID in the operator parameters.");
        }
        int currentPage = 1;
        int pageSize = 10;
        boolean hasMorePages = true;
        LinkedHashSet<String> columnNamesSet = new LinkedHashSet<String>();
        ArrayList<LinkedHashMap<String, Object>> rows = new ArrayList<LinkedHashMap<String, Object>>();
        while (hasMorePages) {
            String url = navopUrl + "/api/v1/node-classes/" + nodeClassUid + "?include_instance_types=True&page=" + currentPage + "&page_size=" + pageSize;
            LogService.getRoot().log(Level.INFO, "Fetching URL " + url);
            try {
                String line;
                HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("Authorization", "Bearer " + token);
                con.setRequestProperty("Accept", "application/json");
                con.setDoOutput(true);
                int responseCode = con.getResponseCode();
                if (responseCode != 200) {
                    throw new OperatorException("Failed to fetch node class from Navops. Received HTTP " + responseCode + " for URL: " + url);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                bufferedReader.close();
                JSONObject jsonResponse = new JSONObject(stringBuilder.toString());
                LogService.getRoot().log(Level.INFO, "JSON Response: " + jsonResponse.toString(2));
                JSONObject object = jsonResponse.getJSONObject("object");
                JSONArray instanceTypesArray = object.getJSONObject("_status").getJSONArray("instance_types");
                for (int i = 0; i < instanceTypesArray.length(); ++i) {
                    JSONObject instanceType = instanceTypesArray.getJSONObject(i);
                    LinkedHashMap<String, Object> flatMap = new LinkedHashMap<String, Object>();
                    JSONObject instanceMeta = instanceType.getJSONObject("_meta");
                    String instanceTypeName = instanceMeta.getString("name");
                    flatMap.put("instance_type", instanceTypeName);
                    columnNamesSet.add("instance_type");
                    for (String key : instanceType.keySet()) {
                        if ("_meta".equals(key)) continue;
                        Object value = instanceType.get(key);
                        if (value instanceof JSONObject) {
                            this.flattenJson((JSONObject)value, key, flatMap);
                        } else {
                            flatMap.put(key, value);
                        }
                        columnNamesSet.add(key.replace(".", "_"));
                    }
                    rows.add(flatMap);
                }
                int totalPages = jsonResponse.optInt("total_pages", 1);
                hasMorePages = currentPage < totalPages;
                ++currentPage;
            }
            catch (ConnectException ce) {
                throw new OperatorException("Could not connect to Navops API at " + url + ". Please check your network or Navops URL.", (Throwable)ce);
            }
            catch (UnknownHostException uhe) {
                throw new OperatorException("Unknown host: " + uhe.getMessage() + ". Please check your Navops URL.", (Throwable)uhe);
            }
            catch (Exception e) {
                throw new OperatorException("Unexpected error while fetching node class data: " + e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        LinkedHashMap<String, Attribute> attrMap = new LinkedHashMap<String, Attribute>();
        for (String string : columnNamesSet) {
            Object object = rows.stream().map(r -> r.get(string)).filter(Objects::nonNull).findFirst().orElse("");
            int ontologyType = object instanceof Number ? 2 : (object instanceof Boolean ? 1 : 5);
            Attribute attr = AttributeFactory.createAttribute((String)string, (int)ontologyType);
            if (ontologyType == 1) {
                attr.getMapping().mapString("true");
                attr.getMapping().mapString("false");
            }
            attributes.add(attr);
            attrMap.put(string, attr);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (Map map : rows) {
            double[] data = new double[attributes.size()];
            for (int j = 0; j < attributes.size(); ++j) {
                String col = ((Attribute)attributes.get(j)).getName();
                Object val = map.getOrDefault(col, null);
                Attribute attr = (Attribute)attributes.get(j);
                double value = val == null ? Double.NaN : (attr.isNumerical() && val instanceof Number ? ((Number)val).doubleValue() : (attr.isNominal() && val instanceof Boolean ? (double)attr.getMapping().mapString(val.toString().toLowerCase()) : (double)attr.getMapping().mapString(val.toString())));
                data[j] = value;
            }
            table.addDataRow((DataRow)new DoubleArrayDataRow(data));
        }
        ExampleSet exampleSet = table.createExampleSet();
        this.connectionSelector.passDataThrough();
        this.outputPort.deliver((IOObject)exampleSet);
    }

    private void flattenJson(JSONObject obj, String prefix, Map<String, Object> out) {
        for (String key : obj.keySet()) {
            String fullKey;
            Object val = obj.get(key);
            String string = fullKey = prefix.isEmpty() ? key : prefix + "_" + key;
            if (val instanceof JSONObject) {
                this.flattenJson((JSONObject)val, fullKey, out);
                continue;
            }
            if (val instanceof JSONArray) {
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.length(); ++i) {
                    Object item = arr.get(i);
                    if (item instanceof JSONObject) {
                        this.flattenJson((JSONObject)item, fullKey + "[" + i + "]", out);
                        continue;
                    }
                    out.put(fullKey + "[" + i + "]", String.valueOf(item));
                }
                continue;
            }
            out.put(fullKey, val);
        }
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_NODE_CLASS_UI, "The node class UID", "", false));
        return types;
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

