/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.adaption.belt.IOTable;
import com.rapidminer.belt.buffer.Buffers;
import com.rapidminer.belt.buffer.NumericBuffer;
import com.rapidminer.belt.buffer.ObjectBuffer;
import com.rapidminer.belt.column.Column;
import com.rapidminer.belt.reader.NumericReader;
import com.rapidminer.belt.reader.ObjectReader;
import com.rapidminer.belt.reader.Readers;
import com.rapidminer.belt.table.Table;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.tools.LogService;
import java.util.ArrayList;
import java.util.logging.Level;

public class GetMinRequiredIntsanceType
extends Operator {
    private InputPort jobsInput = this.getInputPorts().createPort("job set", IOTable.class);
    private InputPort instanceTypeInput = this.getInputPorts().createPort("it set", IOTable.class);
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");

    public GetMinRequiredIntsanceType(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
    }

    public void doWork() throws OperatorException {
        LogService.getRoot().log(Level.INFO, "Get max required instance type...");
        IOTable ioJobTable = (IOTable)this.jobsInput.getData(IOTable.class);
        Table jobTable = ioJobTable.getTable();
        IOTable ioITTable = (IOTable)this.instanceTypeInput.getData(IOTable.class);
        Table itTable = ioITTable.getTable();
        double totalSlots = 0.0;
        double totalMemory = 0.0;
        Column slotsCol = jobTable.column("slots");
        Column memoryCol = jobTable.column("memory");
        NumericReader slotsReader = Readers.numericReader((Column)slotsCol);
        NumericReader memoryReader = Readers.numericReader((Column)memoryCol);
        while (slotsReader.hasRemaining() && memoryReader.hasRemaining()) {
            double slotVal = slotsReader.read();
            double memVal = memoryReader.read();
            totalSlots += Double.isNaN(slotVal) ? 0.0 : slotVal;
            totalMemory += Double.isNaN(memVal) ? 0.0 : memVal;
        }
        int rowCount = itTable.height();
        ObjectBuffer instanceTypeBuffer = Buffers.textBuffer((int)rowCount);
        Column itColumn = itTable.column("instance_type");
        ObjectReader reader = Readers.objectReader((Column)itColumn, String.class);
        int i = 0;
        while (reader.hasRemaining()) {
            instanceTypeBuffer.set(i++, (Object)((String)reader.read()));
        }
        Column cpuColumn = itTable.column("nb_cpu");
        Column ramColumn = itTable.column("ram_size");
        NumericReader cpuReader = Readers.numericReader((Column)cpuColumn);
        NumericReader ramReader = Readers.numericReader((Column)ramColumn);
        NumericBuffer maxNodesBuffer = Buffers.realBuffer((int)rowCount);
        for (int row = 0; row < rowCount; ++row) {
            String instanceName = (String)instanceTypeBuffer.get(row);
            double cpu = cpuReader.read();
            double ram = ramReader.read();
            int requiredCpuNodes = (int)Math.ceil(totalSlots / cpu);
            int requiredRamNodes = (int)Math.ceil(totalMemory / ram);
            int maxNodes = Math.max(requiredCpuNodes, requiredRamNodes);
            maxNodesBuffer.set(row, (double)maxNodes);
            LogService.getRoot().log(Level.INFO, "Instance Type: " + instanceName);
            LogService.getRoot().log(Level.INFO, "  CPU cores per node: " + cpu + ", required nodes by CPU: " + requiredCpuNodes);
            LogService.getRoot().log(Level.INFO, "  RAM per node: " + ram + ", required nodes by RAM: " + requiredRamNodes);
            LogService.getRoot().log(Level.INFO, "  Total slots needed: " + totalSlots + ", total memory needed: " + totalMemory);
            LogService.getRoot().log(Level.INFO, "  => Max nodes required: " + maxNodes);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Attribute instanceAttr = AttributeFactory.createAttribute((String)"instance_type", (int)5);
        Attribute maxNodesAttr = AttributeFactory.createAttribute((String)"max_node_count", (int)2);
        attributes.add(instanceAttr);
        attributes.add(maxNodesAttr);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (int row = 0; row < rowCount; ++row) {
            double[] data = new double[attributes.size()];
            data[0] = instanceAttr.getMapping().mapString((String)instanceTypeBuffer.get(row));
            data[1] = maxNodesBuffer.get(row);
            table.addDataRow((DataRow)new DoubleArrayDataRow(data));
        }
        ExampleSet output = table.createExampleSet();
        this.outputPort.deliver((IOObject)output);
    }
}

