/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.metadata.ExampleSetPrecondition;
import com.rapidminer.operator.ports.metadata.GenerateNewExampleSetMDRule;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetNodesFromActionIdOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");
    private final InputPort inputPort = (InputPort)this.getInputPorts().createPort("action ids");

    public GetNodesFromActionIdOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addRule((MDTransformationRule)new GenerateNewExampleSetMDRule(this.outputPort));
        this.connectionSelector.makeDefaultPortTransformation();
        this.inputPort.addPrecondition((Precondition)new ExampleSetPrecondition(this.inputPort));
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing. Please verify your Navops connection credentials.");
        }
        ExampleSet inputSet = (ExampleSet)this.inputPort.getData(ExampleSet.class);
        Attribute actionIdAttr = inputSet.getAttributes().get("action_id");
        if (actionIdAttr == null) {
            throw new OperatorException("Input ExampleSet must contain a column named 'action_id'.");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(AttributeFactory.createAttribute((String)"action_id", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"node_uid", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"node_name", (int)5));
        attributes.add(AttributeFactory.createAttribute((String)"node_state", (int)5));
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        String navopUrl = configuration.get("url");
        for (Example example : inputSet) {
            String actionId = example.getValueAsString(actionIdAttr);
            if (actionId == null || actionId.trim().isEmpty()) {
                LogService.getRoot().log(Level.WARNING, "Skipping empty action_id row.");
                continue;
            }
            String url = navopUrl + "/api/v1/node-request/actions/" + actionId;
            try {
                String line;
                URL obj = new URL(url);
                HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("Authorization", "Bearer " + token);
                con.setRequestProperty("Accept", "application/json");
                int responseCode = con.getResponseCode();
                if (responseCode != 200) {
                    throw new OperatorException("HTTP " + responseCode + " returned by Navops for URL: " + url);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                in.close();
                JSONObject jsonResponse = new JSONObject(response.toString());
                JSONObject result = jsonResponse.optJSONObject("result");
                if (result == null || result.isEmpty()) continue;
                for (String key : result.keySet()) {
                    JSONArray nodes;
                    JSONObject actionObj = result.optJSONObject(key);
                    if (actionObj == null || (nodes = actionObj.optJSONArray("nodes")) == null || nodes.isEmpty()) continue;
                    for (int i = 0; i < nodes.length(); ++i) {
                        JSONObject node = nodes.getJSONObject(i);
                        JSONObject meta = node.optJSONObject("_meta");
                        JSONObject nodeStatus = node.optJSONObject("_status");
                        String nodeUid = meta != null ? meta.optString("uid", "") : "";
                        String nodeName = meta != null ? meta.optString("name", "") : "";
                        String nodeState = nodeStatus != null ? nodeStatus.optString("state", "") : "";
                        this.addRow(table, attributes, actionId, nodeUid, nodeName, nodeState);
                    }
                }
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Failed to get nodes for " + actionId + ": " + e.getMessage());
            }
        }
        ExampleSet output = table.createExampleSet();
        this.connectionSelector.passDataThrough();
        this.outputPort.deliver((IOObject)output);
    }

    private void addRow(MemoryExampleTable table, List<Attribute> attributes, String actionId, String nodeUid, String nodeName, String nodeState) {
        double[] values = new double[attributes.size()];
        values[0] = attributes.get(0).getMapping().mapString(actionId);
        values[1] = attributes.get(1).getMapping().mapString(nodeUid);
        values[2] = attributes.get(2).getMapping().mapString(nodeName);
        values[3] = attributes.get(3).getMapping().mapString(nodeState);
        table.addDataRow((DataRow)new DoubleArrayDataRow(values));
    }

    public List<ParameterType> getParameterTypes() {
        return super.getParameterTypes();
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

