/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.navops.operator;

import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.util.ConnectionInformationSelector;
import com.rapidminer.connection.util.ConnectionSelectionProvider;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.extension.navops.connection.NavopsConnHandler;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.LogService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class InventoryNodeQueryOperator
extends Operator
implements ConnectionSelectionProvider {
    private final OutputPort outputPort = (OutputPort)this.getOutputPorts().createPort("example set");
    private final ConnectionInformationSelector connectionSelector = new ConnectionInformationSelector((Operator)this, "navops_conn:navops-conn");

    public InventoryNodeQueryOperator(OperatorDescription description) {
        super(description);
        this.connectionSelector.makeDefaultPortTransformation();
        this.getTransformer().addRule(ConnectionInformationSelector.makeConnectionCheckTransformation((ConnectionSelectionProvider)this));
    }

    public List<ParameterType> getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString("state", "Filter by node state (e.g., 'UP').", "", false));
        types.add(new ParameterTypeString("region", "Filter by region (e.g., 'europe-west3').", "", false));
        types.add(new ParameterTypeString("cluster_uid", "Filter by Cluster UID.", "", false));
        types.add(new ParameterTypeString("cloud_environment_uid", "Filter by Cloud Environment UID.", "", false));
        types.add(new ParameterTypeString("node_class_name", "Filter by Node Class Name.", "", false));
        types.add(new ParameterTypeString("node_uid", "Filter by Node ID.", "", false));
        types.add(new ParameterTypeString("node_identifier", "Filter by Node Identifier.", "", false));
        return types;
    }

    public void doWork() throws OperatorException {
        ConnectionInformation connection = this.connectionSelector.getConnection();
        Map<String, String> configuration = NavopsConnHandler.getConfiguration(connection, this);
        String token = NavopsConnHandler.getToken(connection, null);
        if (token == null || token.trim().isEmpty()) {
            throw new OperatorException("Authentication token is missing.");
        }
        String navopUrl = configuration.get("url");
        String url = navopUrl + "/graphql-api/query";
        String stateFilter = this.getParameterAsString("state");
        String regionFilter = this.getParameterAsString("region");
        String cloudEnvironmentUidFilter = this.getParameterAsString("cloud_environment_uid");
        String clusterUidFilter = this.getParameterAsString("cluster_uid");
        String nodeClassNameFilter = this.getParameterAsString("node_class_name");
        String nodeIdFilter = this.getParameterAsString("node_id");
        String nodeIdentifierFilter = this.getParameterAsString("node_identifier");
        try {
            String query = "query ($first: Int, $after: Cursor, $where: InventoryNodeWhereInput, $orderBy: InventoryNodeOrder) { inventoryNodes(first: $first, after: $after, where: $where, orderBy: $orderBy) { edges { node { _meta { uid created updated related } identifier hostname ip_addresses { ip public } virtual_core memory gpu current_cost node_class_uid node_class_name cloud_credential_name cloud_credential_uid cloud_environment_uid cloud_environment_name region cloud_tags agent_role agent_status agent_services node_config_name cost_center_uid cost_center_name _status { state } license_state license_timestamp cloud_connector_uid cloud_connector_name bootstrapper_node_uid current_cost current_cost_millicents instance_cost_millicents disks { name size_gb type } } } pageInfo { startCursor endCursor hasNextPage } totalCount }}";
            String afterCursor = null;
            boolean hasNextPage = true;
            ArrayList<TreeMap<String, String>> flatRows = new ArrayList<TreeMap<String, String>>();
            TreeSet allKeys = new TreeSet();
            while (hasNextPage) {
                String line;
                JSONObject whereClause = new JSONObject();
                if (stateFilter != null && !stateFilter.trim().isEmpty()) {
                    whereClause.put("_status_state_in", (Object)stateFilter);
                } else {
                    whereClause.put("_status_state_neq", (Object)"deleted");
                }
                if (regionFilter != null && !regionFilter.trim().isEmpty()) {
                    whereClause.put("region_in", (Object)regionFilter);
                }
                if (clusterUidFilter != null && !clusterUidFilter.trim().isEmpty()) {
                    JSONObject relatedPathEq = new JSONObject();
                    relatedPathEq.put("path", (Object)"cluster_uid");
                    relatedPathEq.put("value", (Object)clusterUidFilter);
                    whereClause.put("related_path_eq", (Object)relatedPathEq);
                }
                if (cloudEnvironmentUidFilter != null && !cloudEnvironmentUidFilter.trim().isEmpty()) {
                    whereClause.put("cloud_environment_uid_in", (Object)cloudEnvironmentUidFilter);
                }
                if (nodeClassNameFilter != null && !nodeClassNameFilter.trim().isEmpty()) {
                    whereClause.put("node_class_name_in", (Object)nodeClassNameFilter);
                }
                if (nodeIdFilter != null && !nodeIdFilter.trim().isEmpty()) {
                    whereClause.put("uid_in", (Object)nodeIdFilter);
                }
                if (nodeIdentifierFilter != null && !nodeIdentifierFilter.trim().isEmpty()) {
                    whereClause.put("identifier_in", (Object)nodeIdentifierFilter);
                }
                JSONObject variables = new JSONObject().put("where", (Object)whereClause).put("first", 50).put("after", afterCursor);
                JSONObject payload = new JSONObject().put("query", (Object)query).put("variables", (Object)variables);
                HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
                con.setRequestMethod("POST");
                con.setRequestProperty("Authorization", "Bearer " + token);
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("Cookie", "navops-token=" + token);
                con.setDoOutput(true);
                try (OutputStream outputStream = con.getOutputStream();){
                    outputStream.write(payload.toString().getBytes("UTF-8"));
                }
                LogService.getRoot().log(Level.INFO, "Sending request to URL: " + url);
                LogService.getRoot().log(Level.INFO, "Payload: " + payload.toString(2));
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                bufferedReader.close();
                JSONObject jsonResponse = new JSONObject(response.toString());
                JSONObject inventoryNodes = jsonResponse.getJSONObject("data").getJSONObject("inventoryNodes");
                JSONArray nodes = inventoryNodes.getJSONArray("edges");
                for (int i = 0; i < nodes.length(); ++i) {
                    JSONObject node = nodes.getJSONObject(i).getJSONObject("node");
                    TreeMap<String, String> flatMap = new TreeMap<String, String>();
                    this.flattenJson(node, "", flatMap);
                    flatRows.add(flatMap);
                    allKeys.addAll(flatMap.keySet());
                }
                JSONObject pageInfo = inventoryNodes.getJSONObject("pageInfo");
                hasNextPage = pageInfo.getBoolean("hasNextPage");
                afterCursor = pageInfo.optString("endCursor", null);
            }
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            HashMap<String, Attribute> attrMap = new HashMap<String, Attribute>();
            for (String key : allKeys) {
                Attribute attribute = AttributeFactory.createAttribute((String)key, (int)5);
                attributes.add(attribute);
                attrMap.put(key, attribute);
            }
            MemoryExampleTable table = new MemoryExampleTable(attributes);
            for (Map map : flatRows) {
                double[] data = new double[attributes.size()];
                for (int j = 0; j < attributes.size(); ++j) {
                    String key = ((Attribute)attributes.get(j)).getName();
                    String val = map.getOrDefault(key, null);
                    data[j] = val == null ? Double.NaN : (double)((Attribute)attrMap.get(key)).getMapping().mapString(val);
                }
                table.addDataRow((DataRow)new DoubleArrayDataRow(data));
            }
            this.outputPort.deliver((IOObject)table.createExampleSet());
        }
        catch (Exception e) {
            throw new OperatorException("Failed to query inventory nodes: " + e.getMessage(), (Throwable)e);
        }
    }

    private void flattenJson(JSONObject obj, String prefix, Map<String, String> out) {
        for (String key : obj.keySet()) {
            String fullKey;
            Object val = obj.get(key);
            String string = fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            if (fullKey.equals("_meta.uid")) {
                out.put("node_uid", String.valueOf(val));
                continue;
            }
            if (fullKey.equals("_meta.created")) {
                out.put("node_created", String.valueOf(val));
                continue;
            }
            if (fullKey.equals("_meta.updated")) {
                out.put("node_updated", String.valueOf(val));
                continue;
            }
            if (fullKey.equals("_meta.related")) {
                this.flattenJson((JSONObject)val, fullKey, out);
                continue;
            }
            if (fullKey.equals("_meta.related.cluster_uid")) {
                out.put("cluster_uid", String.valueOf(val));
                continue;
            }
            if (fullKey.equals("_meta.related.deployed_by")) {
                out.put("deployed_by", String.valueOf(val));
                continue;
            }
            if (fullKey.equals("_meta.related.resource_request_uid")) {
                out.put("resource_request_uid", String.valueOf(val));
                continue;
            }
            if (fullKey.startsWith("_meta.") || fullKey.startsWith("_meta.related.")) continue;
            if (val instanceof JSONObject) {
                this.flattenJson((JSONObject)val, fullKey, out);
                continue;
            }
            if (val instanceof JSONArray) {
                JSONArray arr = (JSONArray)val;
                for (int i = 0; i < arr.length(); ++i) {
                    Object item = arr.get(i);
                    if (item instanceof JSONObject) {
                        this.flattenJson((JSONObject)item, fullKey + "[" + i + "]", out);
                        continue;
                    }
                    out.put(fullKey + "[" + i + "]", String.valueOf(item));
                }
                continue;
            }
            out.put(fullKey, String.valueOf(val));
        }
    }

    public ConnectionInformationSelector getConnectionSelector() {
        return this.connectionSelector;
    }

    public void setConnectionSelector(ConnectionInformationSelector selector) {
    }
}

